/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractDerivedValueModel;

public class MessageFormatValueModel
extends AbstractDerivedValueModel {
    private final String pattern;
    private final ValueModel[] argumentValueModels;
    private String value;

    public MessageFormatValueModel(String pattern, ValueModel argumentValueModel) {
        this(pattern, new ValueModel[]{argumentValueModel});
    }

    public MessageFormatValueModel(String pattern, ValueModel[] argumentValueModels) {
        super(new HashSet<ValueModel>(Arrays.asList(argumentValueModels)).toArray(new ValueModel[0]));
        this.pattern = pattern;
        this.argumentValueModels = argumentValueModels;
        this.sourceValuesChanged();
    }

    protected void sourceValuesChanged() {
        String oldValue = this.value;
        this.value = MessageFormat.format(this.pattern, this.getArgumentValues());
        this.fireValueChange(oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    private Object[] getArgumentValues() {
        Object[] values = new Object[this.argumentValueModels.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.argumentValueModels[i].getValue();
        }
        return values;
    }
}

