/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.springframework.util.ObjectUtils;

public final class PropertyChangeSupport
implements Serializable {
    private transient EventListenerList listeners;
    private Map children;
    private Object source;
    static final long serialVersionUID = 7162625831330845068L;

    public PropertyChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(PropertyChangeListener.class, listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(PropertyChangeListener.class, listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<EventListener> returnList = new ArrayList<EventListener>();
        if (this.listeners != null) {
            returnList.addAll(Arrays.asList(this.listeners.getListeners(PropertyChangeListener.class)));
        }
        if (this.children != null) {
            Iterator iterator = this.children.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                PropertyChangeSupport child = (PropertyChangeSupport)this.children.get(key);
                PropertyChangeListener[] childListeners = child.getPropertyChangeListeners();
                for (int index = childListeners.length - 1; index >= 0; --index) {
                    returnList.add(new PropertyChangeListenerProxy(key, childListeners[index]));
                }
            }
        }
        return returnList.toArray(new PropertyChangeListener[returnList.size()]);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport child;
        if (this.children == null) {
            this.children = new HashMap();
        }
        if ((child = (PropertyChangeSupport)this.children.get(propertyName)) == null) {
            child = new PropertyChangeSupport(this.source);
            this.children.put(propertyName, child);
        }
        child.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.children == null) {
            return;
        }
        PropertyChangeSupport child = (PropertyChangeSupport)this.children.get(propertyName);
        if (child == null) {
            return;
        }
        child.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        PropertyChangeSupport support;
        ArrayList<PropertyChangeListener> returnList = new ArrayList<PropertyChangeListener>();
        if (this.children != null && (support = (PropertyChangeSupport)this.children.get(propertyName)) != null) {
            returnList.addAll(Arrays.asList(support.getPropertyChangeListeners()));
        }
        return returnList.toArray(new PropertyChangeListener[0]);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        Object newValue;
        Object oldValue = evt.getOldValue();
        if (ObjectUtils.nullSafeEquals((Object)oldValue, (Object)(newValue = evt.getNewValue()))) {
            return;
        }
        String propertyName = evt.getPropertyName();
        PropertyChangeSupport child = null;
        if (this.children != null && this.children != null && propertyName != null) {
            child = (PropertyChangeSupport)this.children.get(propertyName);
        }
        if (this.listeners != null) {
            Object[] listenerList = this.listeners.getListenerList();
            for (int i = 0; i <= listenerList.length - 2; i += 2) {
                if (listenerList[i] != (class$java$beans$PropertyChangeListener == null ? PropertyChangeSupport.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
                ((PropertyChangeListener)listenerList[i + 1]).propertyChange(evt);
            }
        }
        if (child != null) {
            child.firePropertyChange(evt);
        }
    }

    public boolean hasListeners(String propertyName) {
        PropertyChangeSupport child;
        if (this.listeners != null && this.listeners.getListenerCount(PropertyChangeListener.class) > 0) {
            return true;
        }
        if (this.children != null && (child = (PropertyChangeSupport)this.children.get(propertyName)) != null) {
            return child.hasListeners(propertyName);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.listeners != null) {
            Object[] listenerList = this.listeners.getListenerList();
            for (int i = 0; i <= listenerList.length - 2; i += 2) {
                if (listenerList[i] != (class$java$beans$PropertyChangeListener == null ? PropertyChangeSupport.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener) || !((PropertyChangeListener)listenerList[i + 1] instanceof Serializable)) continue;
                s.writeObject(listenerList[i + 1]);
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        s.defaultReadObject();
        while (null != (listenerOrNull = s.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)listenerOrNull);
        }
    }
}

