/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.docking.flexdock;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockableFactory;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.docking.flexdock.FlexDockViewDescriptor;
import org.springframework.richclient.application.support.AbstractApplicationPage;

public class FlexDockApplicationPage
extends AbstractApplicationPage
implements DockableFactory {
    private Viewport port;
    private Map dockables = new HashMap();
    private boolean isLoadingLayout;
    private boolean creatingDockable;
    private PropertyChangeListener activeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("Dockable.ACTIVE".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                View view = (View)evt.getSource();
                PageComponent component = FlexDockApplicationPage.this.findPageComponent(view.getPersistentId());
                FlexDockApplicationPage.this.setActiveComponent(component);
            }
        }
    };

    protected View createView(PageComponent component) {
        View view = new View(component.getId());
        view.setTitle(component.getDisplayName());
        view.setTabText(component.getDisplayName());
        view.setTabIcon(component.getIcon());
        view.setIcon(component.getIcon());
        view.setContentPane((Container)component.getControl());
        view.getViewProperties().addPropertyChangeListener(this.activeHandler);
        this.configureView(component, view, this.getViewDescriptor(component.getId()));
        this.dockables.put(component.getId(), view);
        return view;
    }

    protected void configureView(final PageComponent component, View view, ViewDescriptor descriptor) {
        boolean closable = true;
        boolean pinnable = true;
        boolean dockable = true;
        if (descriptor instanceof FlexDockViewDescriptor) {
            FlexDockViewDescriptor desc = (FlexDockViewDescriptor)descriptor;
            closable = desc.isClosable();
            pinnable = desc.isPinnable();
            dockable = desc.isDockable();
        }
        if (closable) {
            view.addAction("close");
            AbstractButton btn = view.getActionButton("close");
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FlexDockApplicationPage.this.close(component);
                }
            });
        }
        if (pinnable) {
            view.addAction("pin");
        }
        view.getViewProperties().setDockingEnabled(dockable);
    }

    protected JComponent createControl() {
        this.port = new Viewport();
        return this.port;
    }

    public View getView(String id) {
        return (View)this.dockables.get(id);
    }

    protected void doAddPageComponent(PageComponent pageComponent) {
        View view = this.createView(pageComponent);
        this.dockables.put(pageComponent.getId(), view);
        if (!this.isLoadingLayout) {
            DockingManager.display((Dockable)view);
        }
    }

    protected void doRemovePageComponent(PageComponent pageComponent) {
        View view = this.getView(pageComponent.getId());
        if (view != null) {
            DockingManager.close((Dockable)view);
            this.port.revalidate();
            this.port.repaint();
            this.dockables.remove(view);
        }
    }

    protected boolean giveFocusTo(PageComponent pageComponent) {
        if (this.creatingDockable) {
            return false;
        }
        View view = this.getView(pageComponent.getId());
        view.setActive(true);
        Iterator iter = DockingManager.getDockableIds().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            if (id.equals(pageComponent.getId())) continue;
            this.getView(id).setActive(false);
        }
        return true;
    }

    public void loadLayout() {
        this.isLoadingLayout = true;
        this.getControl();
        try {
            DockingManager.loadLayoutModel((boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        this.port.revalidate();
        this.port.repaint();
        this.isLoadingLayout = false;
        View view = this.getView(this.getActiveComponent().getId());
        if (view != null) {
            view.setActive(true);
        }
    }

    public Component getDockableComponent(String id) {
        return null;
    }

    public Dockable getDockable(String id) {
        if (this.dockables.containsKey(id)) {
            return (Dockable)this.dockables.get(id);
        }
        this.creatingDockable = true;
        this.showView(id);
        this.creatingDockable = false;
        return (Dockable)this.dockables.get(id);
    }
}

