/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.docking.vldocking;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableResolver;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableSelectionEvent;
import com.vlsolutions.swing.docking.event.DockableSelectionListener;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageComponentDescriptor;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.PageLayoutBuilder;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.docking.vldocking.VLDockingLayoutManager;
import org.springframework.richclient.application.docking.vldocking.VLDockingPageDescriptor;
import org.springframework.richclient.application.docking.vldocking.ViewDescriptorDockable;
import org.springframework.richclient.application.support.AbstractApplicationPage;
import org.xml.sax.SAXException;

public class VLDockingApplicationPage
extends AbstractApplicationPage
implements PageLayoutBuilder {
    private DockingDesktop desktop;
    private DockingContext dockingContext;
    private VLDockingLayoutManager layoutManager = null;
    private boolean resolving = false;
    private Resource initialLayout = null;

    public VLDockingApplicationPage(ApplicationWindow window, PageDescriptor pageDescriptor) {
        super(window, pageDescriptor);
        if (pageDescriptor instanceof VLDockingPageDescriptor) {
            VLDockingPageDescriptor descriptor = (VLDockingPageDescriptor)pageDescriptor;
            this.setLayoutManager(descriptor.getLayoutManager());
            this.setInitialLayout(descriptor.getInitialLayout());
        }
    }

    protected PageComponent getPageComponent(Dockable dockable) {
        if (dockable instanceof ViewDescriptorDockable) {
            return ((ViewDescriptorDockable)dockable).getPageComponent();
        }
        return null;
    }

    protected Dockable getDockable(PageComponent pageComponent) {
        DockableState[] states = this.desktop.getDockables();
        for (int i = 0; i < states.length; ++i) {
            Dockable dockable = states[i].getDockable();
            PageComponent pc = this.getPageComponent(dockable);
            if (pc != pageComponent) continue;
            return dockable;
        }
        return null;
    }

    protected boolean giveFocusTo(PageComponent pageComponent) {
        Dockable dockable = this.getDockable(pageComponent);
        if (dockable == null) {
            return false;
        }
        return pageComponent.getControl().requestFocusInWindow();
    }

    public void addView(String viewDescriptorId) {
        this.showView(viewDescriptorId);
    }

    protected void doAddPageComponent(PageComponent pageComponent) {
        if (this.resolving) {
            return;
        }
        pageComponent.getControl();
        Dockable dockable = this.getDockable(pageComponent);
        if (dockable != null) {
            return;
        }
        dockable = this.createDockable(pageComponent);
        this.getLayoutManager().addDockable(this.desktop, dockable);
    }

    protected Dockable createDockable(PageComponent pageComponent) {
        return this.createDockable(this.getViewDescriptor(pageComponent.getId()), pageComponent);
    }

    protected Dockable createDockable(ViewDescriptor descriptor, PageComponent pageComponent) {
        return new ViewDescriptorDockable(descriptor, pageComponent);
    }

    protected void doRemovePageComponent(PageComponent pageComponent) {
        Dockable dockable = this.getDockable(pageComponent);
        if (dockable != null) {
            this.getLayoutManager().removeDockable(this.desktop, dockable);
        }
    }

    protected JComponent createControl() {
        String name = this.getPageDescriptor().getId();
        this.desktop = new DockingDesktop(name, this.getDockingContext());
        this.desktop.setName(name);
        DockableListener listener = new DockableListener();
        this.desktop.addDockableStateChangeListener((DockableStateChangeListener)listener);
        this.desktop.addDockableStateWillChangeListener((DockableStateWillChangeListener)listener);
        this.desktop.addDockableSelectionListener((DockableSelectionListener)listener);
        if (this.initialLayout != null) {
            try {
                InputStream in = this.initialLayout.getInputStream();
                this.desktop.getContext().readXML(in);
                in.close();
            }
            catch (IOException ioe) {
                this.logger.warn((Object)("Error reading workspace layout " + this.initialLayout + ", using defaults"), (Throwable)ioe);
                this.getPageDescriptor().buildInitialLayout((PageLayoutBuilder)this);
            }
            catch (SAXException saxe) {
                this.logger.warn((Object)("Error parsing workspace layout " + this.initialLayout + ", using defaults"), (Throwable)saxe);
                this.getPageDescriptor().buildInitialLayout((PageLayoutBuilder)this);
            }
            catch (ParserConfigurationException pce) {
                this.logger.warn((Object)("Error parsing workspace layout " + this.initialLayout + ", using defaults"), (Throwable)pce);
                this.getPageDescriptor().buildInitialLayout((PageLayoutBuilder)this);
            }
            if (this.desktop.getDockables().length == 0) {
                this.getPageDescriptor().buildInitialLayout((PageLayoutBuilder)this);
            }
        } else {
            this.getPageDescriptor().buildInitialLayout((PageLayoutBuilder)this);
        }
        return this.desktop;
    }

    protected void updatePageComponentProperties(PageComponent pageComponent) {
        Dockable dockable = this.getDockable(pageComponent);
        DockKey dockKey = dockable.getDockKey();
        if (pageComponent.getIcon() != null) {
            dockKey.setIcon(pageComponent.getIcon());
        }
        dockKey.setName(pageComponent.getDisplayName());
        dockKey.setTooltip(pageComponent.getCaption());
    }

    public DockingContext getDockingContext() {
        if (this.dockingContext == null) {
            this.dockingContext = new DockingContext();
            this.dockingContext.setDockableResolver((DockableResolver)new ViewDescriptorResolver());
        }
        return this.dockingContext;
    }

    private VLDockingLayoutManager getLayoutManager() {
        if (this.layoutManager == null) {
            this.layoutManager = new DefaultLayoutManager();
        }
        return this.layoutManager;
    }

    public void setLayoutManager(VLDockingLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public void setInitialLayout(Resource initialLayout) {
        this.initialLayout = initialLayout;
    }

    public boolean close() {
        if (this.initialLayout != null) {
            File file = null;
            try {
                file = this.initialLayout.getFile();
                if (file.canWrite()) {
                    try {
                        FileOutputStream out = new FileOutputStream(file);
                        this.desktop.getContext().writeXML((OutputStream)out);
                        ((OutputStream)out).close();
                    }
                    catch (IOException ioe) {
                        this.logger.warn((Object)("Error saving desktop layout to " + file), (Throwable)ioe);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.close();
    }

    private class DefaultLayoutManager
    implements VLDockingLayoutManager {
        private DefaultLayoutManager() {
        }

        public void addDockable(DockingDesktop desktop, Dockable dockable) {
            desktop.addDockable(dockable);
        }

        public void removeDockable(DockingDesktop desktop, Dockable dockable) {
            desktop.remove(dockable);
        }
    }

    private class ViewDescriptorResolver
    implements DockableResolver {
        private ViewDescriptorResolver() {
        }

        public Dockable resolveDockable(String keyName) {
            ViewDescriptor descriptor = VLDockingApplicationPage.this.getViewDescriptor(keyName);
            if (descriptor == null) {
                return null;
            }
            PageComponent pageComponent = VLDockingApplicationPage.this.createPageComponent((PageComponentDescriptor)descriptor);
            VLDockingApplicationPage.this.resolving = true;
            VLDockingApplicationPage.this.addPageComponent(pageComponent);
            VLDockingApplicationPage.this.resolving = false;
            Dockable dockable = VLDockingApplicationPage.this.createDockable(descriptor, pageComponent);
            return dockable;
        }
    }

    private class DockableListener
    implements DockableStateChangeListener,
    DockableStateWillChangeListener,
    DockableSelectionListener {
        private DockableListener() {
        }

        public void dockableStateWillChange(DockableStateWillChangeEvent event) {
            ViewDescriptorDockable vdd;
            PageComponent pc;
            Dockable dockable;
            DockableState futureState = event.getFutureState();
            if (futureState.isClosed() && (dockable = futureState.getDockable()) instanceof ViewDescriptorDockable && !(pc = (vdd = (ViewDescriptorDockable)dockable).getPageComponent()).canClose()) {
                event.cancel();
            }
        }

        public void dockableStateChanged(DockableStateChangeEvent event) {
            DockableState previousState = event.getPreviousState();
            DockableState newState = event.getNewState();
            Dockable dockable = newState.getDockable();
            PageComponent pc = VLDockingApplicationPage.this.getPageComponent(dockable);
            if (pc == null) {
                return;
            }
            if (previousState != null && !previousState.isClosed() && newState.isClosed()) {
                pc.getContext().getPage().close(pc);
            }
        }

        public void selectionChanged(DockableSelectionEvent e) {
            PageComponent pc;
            Dockable dockable = e.getSelectedDockable();
            if (dockable != null && (pc = VLDockingApplicationPage.this.getPageComponent(dockable)) != null) {
                VLDockingApplicationPage.this.setActiveComponent(pc);
            }
        }
    }
}

