/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.docking.vldocking;

import com.vlsolutions.swing.docking.DockingContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.ApplicationPageFactory;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.PageListener;
import org.springframework.richclient.application.docking.vldocking.VLDockingApplicationPage;
import org.springframework.richclient.application.docking.vldocking.VLDockingPageDescriptor;

public class VLDockingApplicationPageFactory
implements ApplicationPageFactory {
    private static final Log logger = LogFactory.getLog((Class)VLDockingApplicationPageFactory.class);
    private boolean reusePages;
    private Map pageCache = new HashMap();

    public ApplicationPage createApplicationPage(ApplicationWindow window, PageDescriptor descriptor) {
        VLDockingApplicationPage page;
        if (this.reusePages && (page = this.findPage(window, descriptor)) != null) {
            return page;
        }
        page = new VLDockingApplicationPage(window, descriptor);
        if (this.reusePages) {
            this.cachePage(page);
        }
        window.addPageListener(new PageListener(){

            public void pageOpened(ApplicationPage page) {
            }

            public void pageClosed(ApplicationPage page) {
                VLDockingApplicationPage vlDockingApplicationPage = (VLDockingApplicationPage)page;
                VLDockingApplicationPageFactory.this.saveDockingContext(vlDockingApplicationPage);
            }
        });
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDockingContext(VLDockingApplicationPage dockingPage) {
        DockingContext dockingContext = dockingPage.getDockingContext();
        VLDockingPageDescriptor vlDockingPageDescriptor = (VLDockingPageDescriptor)((Object)Application.instance().getApplicationContext().getBean(dockingPage.getId()));
        FilterOutputStream buffOs = null;
        try {
            File desktopLayoutFile = vlDockingPageDescriptor.getInitialLayout().getFile();
            this.checkForConfigPath(desktopLayoutFile);
            buffOs = new BufferedOutputStream(new FileOutputStream(desktopLayoutFile));
            dockingContext.writeXML((OutputStream)buffOs);
            buffOs.close();
            logger.debug((Object)("Wrote docking context to config file " + desktopLayoutFile));
        }
        catch (IOException e) {
            logger.warn((Object)"Error writing VLDocking config", (Throwable)e);
        }
        finally {
            try {
                buffOs.close();
            }
            catch (Exception e) {}
        }
    }

    private void checkForConfigPath(File configFile) {
        String desktopLayoutFilePath = configFile.getAbsolutePath();
        String configDirPath = desktopLayoutFilePath.substring(0, desktopLayoutFilePath.lastIndexOf(System.getProperty("file.separator")));
        File configDir = new File(configDirPath);
        if (!configDir.exists()) {
            configDir.mkdirs();
            logger.debug((Object)"Newly created config directory");
        }
    }

    protected VLDockingApplicationPage findPage(ApplicationWindow window, PageDescriptor descriptor) {
        Map pages = (Map)this.pageCache.get(window);
        if (pages == null) {
            return null;
        }
        return (VLDockingApplicationPage)((Object)pages.get(descriptor.getId()));
    }

    protected void cachePage(VLDockingApplicationPage page) {
        HashMap<String, VLDockingApplicationPage> pages = (HashMap<String, VLDockingApplicationPage>)this.pageCache.get(page.getWindow());
        if (pages == null) {
            pages = new HashMap<String, VLDockingApplicationPage>();
            this.pageCache.put(page.getWindow(), pages);
        }
        pages.put(page.getId(), page);
    }

    public void setReusePages(boolean reusePages) {
        this.reusePages = reusePages;
    }
}

