/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.docking.vldocking;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingConstants;
import java.awt.Component;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.docking.vldocking.VLDockingViewDescriptor;

public class ViewDescriptorDockable
implements Dockable {
    private ViewDescriptor viewDescriptor;
    private PageComponent pageComponent;
    private DockKey dockKey;

    public ViewDescriptorDockable(ViewDescriptor viewDescriptor) {
        this(viewDescriptor, null);
    }

    public ViewDescriptorDockable(ViewDescriptor viewDescriptor, PageComponent pageComponent) {
        this.viewDescriptor = viewDescriptor;
        this.pageComponent = pageComponent;
        this.dockKey = new DockKey(viewDescriptor.getId());
        this.dockKey.setName(viewDescriptor.getDisplayName());
        this.dockKey.setTooltip(viewDescriptor.getCaption());
        this.dockKey.setIcon(viewDescriptor.getIcon());
        boolean autoHideEnabled = VLDockingViewDescriptor.DEFAULT_AUTOHIDEENABLED;
        DockingConstants.Hide autoHideBorder = VLDockingViewDescriptor.DEFAULT_AUTOHIDEBORDER;
        boolean closeEnabled = VLDockingViewDescriptor.DEFAULT_CLOSEENABLED;
        boolean floatEnabled = VLDockingViewDescriptor.DEFAULT_FLOATENABLED;
        boolean maximizeEnabled = VLDockingViewDescriptor.DEFAULT_MAXIMIZEENABLED;
        if (viewDescriptor instanceof VLDockingViewDescriptor) {
            VLDockingViewDescriptor dockingViewDescriptor = (VLDockingViewDescriptor)viewDescriptor;
            autoHideEnabled = dockingViewDescriptor.isAutoHideEnabled();
            autoHideBorder = dockingViewDescriptor.getAutoHideBorder();
            closeEnabled = dockingViewDescriptor.isCloseEnabled();
            floatEnabled = dockingViewDescriptor.isFloatEnabled();
            maximizeEnabled = dockingViewDescriptor.isMaximizeEnabled();
        }
        this.dockKey.setAutoHideEnabled(autoHideEnabled);
        this.dockKey.setAutoHideBorder(autoHideBorder);
        this.dockKey.setCloseEnabled(closeEnabled);
        this.dockKey.setFloatEnabled(floatEnabled);
        this.dockKey.setMaximizeEnabled(maximizeEnabled);
    }

    public PageComponent getPageComponent() {
        if (this.pageComponent == null) {
            this.pageComponent = this.viewDescriptor.createPageComponent();
        }
        return this.pageComponent;
    }

    public Component getComponent() {
        return this.getPageComponent().getControl();
    }

    public DockKey getDockKey() {
        return this.dockKey;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("viewDescriptor", (Object)this.viewDescriptor.getId()).toString();
    }
}

