/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.binding.form.support.MessageCodeStrategy;
import org.springframework.util.StringUtils;

public class DefaultMessageCodeStrategy
implements MessageCodeStrategy {
    public String[] getMessageCodes(String contextId, String field, String[] suffixes) {
        boolean hasContextId = StringUtils.hasText((String)contextId);
        String[] fieldPathElements = StringUtils.delimitedListToStringArray((String)field, (String)".");
        ArrayList keys = new ArrayList((hasContextId ? 2 * fieldPathElements.length : fieldPathElements.length) * (suffixes == null ? 1 : suffixes.length));
        if (hasContextId) {
            String prefix = contextId + '.';
            this.addKeys(keys, prefix, fieldPathElements, suffixes);
        }
        this.addKeys(keys, "", fieldPathElements, suffixes);
        return keys.toArray(new String[keys.size()]);
    }

    private void addKeys(Collection keys, String prefix, String[] fieldPathElements, String[] suffix) {
        int size = fieldPathElements.length;
        int suffixSize = suffix == null ? 0 : suffix.length;
        for (int i = 0; i < size; ++i) {
            int j;
            StringBuffer path = new StringBuffer(prefix);
            for (j = i; j < size; ++j) {
                path.append(fieldPathElements[j]);
                if (j + 1 >= size) continue;
                path.append('.');
            }
            if (suffixSize == 0) {
                keys.add(path.toString());
                continue;
            }
            for (j = 0; j < suffixSize; ++j) {
                String currentSuffix = suffix[j];
                if (StringUtils.hasText((String)currentSuffix)) {
                    keys.add(path.toString() + "." + currentSuffix);
                    continue;
                }
                keys.add(path.toString());
            }
        }
    }
}

