/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.validation.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.binding.validation.ValidationListener;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.ValidationResultsModel;
import org.springframework.binding.validation.support.DefaultValidationResults;
import org.springframework.binding.validation.support.EmptyValidationResults;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.util.Assert;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ObjectUtils;

public class DefaultValidationResultsModel
implements ValidationResultsModel,
ValidationListener,
PropertyChangeListener {
    private final EventListenerListHelper validationListeners = new EventListenerListHelper(ValidationListener.class);
    private final CachingMapDecorator propertyValidationListeners = new CachingMapDecorator(){

        protected Object create(Object propertyName) {
            return new EventListenerListHelper(class$org$springframework$binding$validation$ValidationListener == null ? (class$org$springframework$binding$validation$ValidationListener = DefaultValidationResultsModel.class$("org.springframework.binding.validation.ValidationListener")) : class$org$springframework$binding$validation$ValidationListener);
        }
    };
    private final CachingMapDecorator propertyChangeListeners = new CachingMapDecorator(){

        protected Object create(Object propertyName) {
            return new EventListenerListHelper(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefaultValidationResultsModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
        }
    };
    private final ValidationResultsModel delegateFor;
    private List children = new ArrayList();
    private ValidationResults validationResults = EmptyValidationResults.INSTANCE;
    private boolean hasErrors = false;
    private boolean hasWarnings = false;
    private boolean hasInfo = false;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public DefaultValidationResultsModel() {
        this.delegateFor = this;
    }

    public DefaultValidationResultsModel(ValidationResultsModel delegateFor) {
        this.delegateFor = delegateFor;
    }

    public void updateValidationResults(ValidationResults newValidationResults) {
        Assert.required((Object)newValidationResults, (String)"newValidationResults");
        ValidationResults oldValidationResults = this.validationResults;
        this.validationResults = newValidationResults;
        if (oldValidationResults.getMessageCount() == 0 && this.validationResults.getMessageCount() == 0) {
            return;
        }
        this.fireChangedEvents();
        Iterator i = this.propertyValidationListeners.keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            if (oldValidationResults.getMessageCount(propertyName) <= 0 && this.validationResults.getMessageCount(propertyName) <= 0) continue;
            this.fireValidationResultsChanged(propertyName);
        }
    }

    public void addMessage(ValidationMessage validationMessage) {
        if (!this.validationResults.getMessages().contains(validationMessage)) {
            ValidationResults oldValidationResults = this.validationResults;
            ArrayList<ValidationMessage> newMessages = new ArrayList<ValidationMessage>(oldValidationResults.getMessages());
            newMessages.add(validationMessage);
            this.validationResults = new DefaultValidationResults(newMessages);
            this.fireChangedEvents();
            this.fireValidationResultsChanged(validationMessage.getProperty());
        }
    }

    public void removeMessage(ValidationMessage validationMessage) {
        if (this.validationResults.getMessages().contains(validationMessage)) {
            ValidationResults oldValidationResults = this.validationResults;
            ArrayList newMessages = new ArrayList(oldValidationResults.getMessages());
            newMessages.remove(validationMessage);
            this.validationResults = new DefaultValidationResults(newMessages);
            this.fireChangedEvents();
            this.fireValidationResultsChanged(validationMessage.getProperty());
        }
    }

    public void replaceMessage(ValidationMessage messageToReplace, ValidationMessage replacementMessage) {
        ValidationResults oldValidationResults = this.validationResults;
        ArrayList<ValidationMessage> newMessages = new ArrayList<ValidationMessage>(oldValidationResults.getMessages());
        boolean containsMessageToReplace = this.validationResults.getMessages().contains(messageToReplace);
        if (containsMessageToReplace) {
            newMessages.remove(messageToReplace);
        }
        newMessages.add(replacementMessage);
        this.validationResults = new DefaultValidationResults(newMessages);
        this.fireChangedEvents();
        if (containsMessageToReplace && !ObjectUtils.nullSafeEquals((Object)messageToReplace.getProperty(), (Object)replacementMessage.getProperty())) {
            this.fireValidationResultsChanged(messageToReplace.getProperty());
        }
        this.fireValidationResultsChanged(replacementMessage.getProperty());
    }

    public void clearAllValidationResults() {
        this.updateValidationResults(EmptyValidationResults.INSTANCE);
    }

    public boolean getHasErrors() {
        return this.hasErrors;
    }

    private void updateErrors() {
        boolean oldErrors = this.hasErrors;
        this.hasErrors = false;
        if (this.validationResults.getHasErrors()) {
            this.hasErrors = true;
        } else {
            Iterator childIter = this.children.iterator();
            while (childIter.hasNext()) {
                ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
                if (!childModel.getHasErrors()) continue;
                this.hasErrors = true;
                break;
            }
        }
        this.firePropertyChange("hasErrors", oldErrors, this.hasErrors);
    }

    public boolean getHasInfo() {
        return this.hasInfo;
    }

    private void updateInfo() {
        boolean oldInfo = this.hasInfo;
        this.hasInfo = false;
        if (this.validationResults.getHasInfo()) {
            this.hasInfo = true;
        } else {
            Iterator childIter = this.children.iterator();
            while (childIter.hasNext()) {
                ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
                if (!childModel.getHasInfo()) continue;
                this.hasInfo = true;
                break;
            }
        }
        this.firePropertyChange("hasInfo", oldInfo, this.hasInfo);
    }

    public boolean getHasWarnings() {
        return this.hasWarnings;
    }

    private void updateWarnings() {
        boolean oldWarnings = this.hasWarnings;
        this.hasWarnings = false;
        if (this.validationResults.getHasWarnings()) {
            this.hasWarnings = true;
        } else {
            Iterator childIter = this.children.iterator();
            while (childIter.hasNext()) {
                ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
                if (!childModel.getHasWarnings()) continue;
                this.hasWarnings = true;
                break;
            }
        }
        this.firePropertyChange("hasWarnings", oldWarnings, this.hasWarnings);
    }

    public int getMessageCount() {
        int count = this.validationResults.getMessageCount();
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
            count += childModel.getMessageCount();
        }
        return count;
    }

    public int getMessageCount(Severity severity) {
        int count = this.validationResults.getMessageCount(severity);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
            count += childModel.getMessageCount(severity);
        }
        return count;
    }

    public int getMessageCount(String propertyName) {
        int count = this.validationResults.getMessageCount(propertyName);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
            count += childModel.getMessageCount(propertyName);
        }
        return count;
    }

    public Set getMessages() {
        HashSet messages = new HashSet();
        messages.addAll(this.validationResults.getMessages());
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
            messages.addAll(childModel.getMessages());
        }
        return messages;
    }

    public Set getMessages(Severity severity) {
        HashSet messages = new HashSet();
        messages.addAll(this.validationResults.getMessages(severity));
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
            messages.addAll(childModel.getMessages(severity));
        }
        return messages;
    }

    public Set getMessages(String propertyName) {
        HashSet messages = new HashSet();
        messages.addAll(this.validationResults.getMessages(propertyName));
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            ValidationResultsModel childModel = (ValidationResultsModel)childIter.next();
            messages.addAll(childModel.getMessages(propertyName));
        }
        return messages;
    }

    public void addValidationListener(ValidationListener listener) {
        this.validationListeners.add((Object)listener);
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove((Object)listener);
    }

    public void addValidationListener(String propertyName, ValidationListener listener) {
        this.getValidationListeners(propertyName).add((Object)listener);
    }

    public void removeValidationListener(String propertyName, ValidationListener listener) {
        this.getValidationListeners(propertyName).remove((Object)listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeListeners(propertyName).add((Object)listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeListeners(propertyName).remove((Object)listener);
    }

    protected void fireChangedEvents() {
        this.updateErrors();
        this.updateWarnings();
        this.updateInfo();
        this.fireValidationResultsChanged();
    }

    protected void fireValidationResultsChanged() {
        this.validationListeners.fire("validationResultsChanged", (Object)this.delegateFor);
    }

    protected void fireValidationResultsChanged(String propertyName) {
        Iterator i = this.getValidationListeners(propertyName).iterator();
        while (i.hasNext()) {
            ((ValidationListener)i.next()).validationResultsChanged((ValidationResults)this.delegateFor);
        }
    }

    protected EventListenerListHelper getValidationListeners(String propertyName) {
        return (EventListenerListHelper)this.propertyValidationListeners.get((Object)propertyName);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        EventListenerListHelper propertyChangeListeners;
        if (oldValue != newValue && (propertyChangeListeners = this.getPropertyChangeListeners(propertyName)).hasListeners()) {
            PropertyChangeEvent event = new PropertyChangeEvent(this.delegateFor, propertyName, oldValue, newValue);
            propertyChangeListeners.fire("propertyChange", (Object)event);
        }
    }

    protected EventListenerListHelper getPropertyChangeListeners(String propertyName) {
        return (EventListenerListHelper)this.propertyChangeListeners.get((Object)propertyName);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("messages", (Object)this.getMessages()).toString();
    }

    public void add(ValidationResultsModel validationResultsModel) {
        if (this.children.add(validationResultsModel)) {
            validationResultsModel.addValidationListener((ValidationListener)this);
            validationResultsModel.addPropertyChangeListener("hasErrors", (PropertyChangeListener)this);
            validationResultsModel.addPropertyChangeListener("hasWarnings", (PropertyChangeListener)this);
            validationResultsModel.addPropertyChangeListener("hasInfo", (PropertyChangeListener)this);
            if (validationResultsModel.getMessageCount() > 0) {
                this.fireChangedEvents();
            }
        }
    }

    public void remove(ValidationResultsModel validationResultsModel) {
        if (this.children.remove(validationResultsModel)) {
            validationResultsModel.removeValidationListener((ValidationListener)this);
            validationResultsModel.removePropertyChangeListener("hasErrors", (PropertyChangeListener)this);
            validationResultsModel.removePropertyChangeListener("hasWarnings", (PropertyChangeListener)this);
            validationResultsModel.removePropertyChangeListener("hasInfo", (PropertyChangeListener)this);
            if (validationResultsModel.getMessageCount() > 0) {
                this.fireChangedEvents();
            }
        }
    }

    public void validationResultsChanged(ValidationResults results) {
        this.fireValidationResultsChanged();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "hasErrors") {
            this.updateErrors();
        } else if (evt.getPropertyName() == "hasWarnings") {
            this.updateWarnings();
        } else if (evt.getPropertyName() == "hasInfo") {
            this.updateInfo();
        }
    }
}

