/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.validation.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.support.FormModelPropertyAccessStrategy;
import org.springframework.binding.validation.RichValidator;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.support.DefaultValidationMessage;
import org.springframework.binding.validation.support.DefaultValidationResults;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.Severity;
import org.springframework.rules.PropertyConstraintProvider;
import org.springframework.rules.Rules;
import org.springframework.rules.RulesSource;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.reporting.BeanValidationResultsCollector;
import org.springframework.rules.reporting.MessageTranslator;
import org.springframework.rules.reporting.MessageTranslatorFactory;
import org.springframework.rules.reporting.ObjectNameResolver;
import org.springframework.rules.reporting.PropertyResults;

public class RulesValidator
implements RichValidator,
ObjectNameResolver {
    private static final Log logger = LogFactory.getLog((Class)RulesValidator.class);
    private final DefaultValidationResults results = new DefaultValidationResults();
    private final MessageTranslator messageTranslator;
    private final Map validationErrors = new HashMap();
    private final FormModel formModel;
    private BeanValidationResultsCollector validationResultsCollector;
    private RulesSource rulesSource;
    private String rulesContextId = null;
    private Class objectClass;

    public RulesValidator(FormModel formModel) {
        this(formModel, null);
    }

    public RulesValidator(FormModel formModel, RulesSource rulesSource) {
        this.formModel = formModel;
        this.rulesSource = rulesSource;
        this.validationResultsCollector = new BeanValidationResultsCollector(new FormModelPropertyAccessStrategy(formModel));
        MessageTranslatorFactory factory = (MessageTranslatorFactory)ApplicationServicesLocator.services().getService(MessageTranslatorFactory.class);
        this.messageTranslator = factory.createTranslator(this);
    }

    public ValidationResults validate(Object object) {
        return this.validate(object, null);
    }

    public ValidationResults validate(Object object, String propertyName) {
        if (propertyName == null || this.objectClass != null && this.objectClass != object.getClass()) {
            this.clearMessages();
        }
        this.objectClass = object.getClass();
        Rules rules = null;
        if (object instanceof PropertyConstraintProvider) {
            PropertyConstraintProvider propertyConstraintProvider = (PropertyConstraintProvider)object;
            if (propertyName != null) {
                PropertyConstraint validationRule = propertyConstraintProvider.getPropertyConstraint(propertyName);
                this.checkRule(validationRule);
            } else {
                Iterator fieldNamesIter = this.formModel.getFieldNames().iterator();
                while (fieldNamesIter.hasNext()) {
                    PropertyConstraint validationRule = propertyConstraintProvider.getPropertyConstraint((String)fieldNamesIter.next());
                    this.checkRule(validationRule);
                }
            }
        } else if (this.getRulesSource() != null) {
            rules = this.getRulesSource().getRules(this.objectClass, this.getRulesContextId());
            if (rules != null) {
                Iterator i = rules.iterator();
                while (i.hasNext()) {
                    PropertyConstraint validationRule = (PropertyConstraint)i.next();
                    if (propertyName == null) {
                        if (!this.formModel.hasValueModel(validationRule.getPropertyName())) continue;
                        this.checkRule(validationRule);
                        continue;
                    }
                    if (!validationRule.isDependentOn(propertyName)) continue;
                    this.checkRule(validationRule);
                }
            }
        } else {
            logger.debug((Object)"No rules source has been configured; please set a valid reference to enable rules-based validation.");
        }
        return this.results;
    }

    private void checkRule(PropertyConstraint validationRule) {
        if (validationRule == null) {
            return;
        }
        BeanValidationResultsCollector resultsCollector = this.takeResultsCollector();
        PropertyResults results = resultsCollector.collectPropertyResults(validationRule);
        this.returnResultsCollector(resultsCollector);
        if (results == null) {
            this.constraintSatisfied(validationRule);
        } else {
            this.constraintViolated(validationRule, results);
        }
    }

    protected void constraintSatisfied(PropertyConstraint exp) {
        ValidationMessage message = (ValidationMessage)this.validationErrors.remove(exp);
        if (message != null) {
            this.results.removeMessage(message);
        }
    }

    protected void constraintViolated(PropertyConstraint exp, PropertyResults propertyResults) {
        ValidationMessage oldMessage;
        DefaultValidationMessage message = new DefaultValidationMessage(exp.getPropertyName(), Severity.ERROR, this.messageTranslator.getMessage(propertyResults));
        if (!((Object)message).equals(oldMessage = (ValidationMessage)this.validationErrors.get(exp))) {
            this.results.removeMessage(oldMessage);
            this.validationErrors.put(exp, message);
            this.results.addMessage(message);
        }
    }

    private RulesSource getRulesSource() {
        if (this.rulesSource == null) {
            this.rulesSource = (RulesSource)ApplicationServicesLocator.services().getService(RulesSource.class);
        }
        return this.rulesSource;
    }

    private BeanValidationResultsCollector takeResultsCollector() {
        BeanValidationResultsCollector resultsCollector = this.validationResultsCollector;
        if (resultsCollector != null) {
            this.validationResultsCollector = null;
        } else {
            resultsCollector = new BeanValidationResultsCollector(new FormModelPropertyAccessStrategy(this.formModel));
        }
        return resultsCollector;
    }

    private void returnResultsCollector(BeanValidationResultsCollector resultsCollector) {
        this.validationResultsCollector = resultsCollector;
    }

    public String getRulesContextId() {
        return this.rulesContextId;
    }

    public void setRulesContextId(String rulesContextId) {
        this.rulesContextId = rulesContextId;
    }

    public String resolveObjectName(String objectName) {
        return this.formModel.getFieldFace(objectName).getDisplayName();
    }

    public void clearMessages() {
        this.results.clearMessages();
        this.validationErrors.clear();
    }
}

