/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.validation.support;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.validation.RichValidator;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.support.DefaultValidationMessage;
import org.springframework.binding.validation.support.DefaultValidationResults;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.Severity;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.StringUtils;
import org.springmodules.validation.valang.ValangValidator;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.AbstractMathFunction;
import org.springmodules.validation.valang.functions.BeanPropertyFunction;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.functions.MapEntryFunction;
import org.springmodules.validation.valang.predicates.BasicValidationRule;
import org.springmodules.validation.valang.predicates.GenericTestPredicate;

public class ValangRichValidator
implements RichValidator {
    private final Map propertyRules = new CachingMapDecorator(false){

        protected Object create(Object key) {
            return new ArrayList();
        }
    };
    private final DefaultValidationResults results = new DefaultValidationResults();
    private final Map validationErrors = new HashMap();
    private final FormModel formModel;
    private final Collection allRules;
    private MessageSourceAccessor messageSourceAccessor;

    public ValangRichValidator(FormModel formModel, ValangValidator validator) {
        this.formModel = formModel;
        this.allRules = validator.getRules();
        this.initPropertyRules();
    }

    private void initPropertyRules() {
        Iterator i = this.allRules.iterator();
        while (i.hasNext()) {
            BasicValidationRule rule = (BasicValidationRule)i.next();
            Set propertiesUsedByRule = this.getPropertiesUsedByRule(rule);
            Iterator j = propertiesUsedByRule.iterator();
            while (j.hasNext()) {
                String propertyName = (String)j.next();
                ((List)this.propertyRules.get(propertyName)).add(rule);
            }
        }
    }

    public MessageSourceAccessor getMessageSourceAccessor() {
        if (this.messageSourceAccessor == null) {
            this.messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return this.messageSourceAccessor;
    }

    public void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }

    private Set getPropertiesUsedByRule(BasicValidationRule rule) {
        PropertiesUsedByRuleCollector collector = new PropertiesUsedByRuleCollector(rule);
        return collector.getPropertiesUsedByRule();
    }

    public ValidationResults validate(Object object) {
        return this.validate(object, null);
    }

    public ValidationResults validate(Object object, String propertyName) {
        Collection rulesToCheck = this.getRulesEffectedByProperty(propertyName);
        Iterator i = rulesToCheck.iterator();
        while (i.hasNext()) {
            this.checkRule((BasicValidationRule)i.next());
        }
        return null;
    }

    protected Collection getRulesEffectedByProperty(String propertyName) {
        return propertyName == null ? this.allRules : (Collection)this.propertyRules.get(propertyName);
    }

    private void checkRule(BasicValidationRule rule) {
        if (rule.getPredicate().evaluate(this.getSourceObject())) {
            this.ruleSatisfied(rule);
        } else {
            this.ruleViolated(rule);
        }
    }

    protected void ruleSatisfied(BasicValidationRule rule) {
        ValidationMessage message = (ValidationMessage)this.validationErrors.remove(rule);
        if (message != null) {
            this.results.removeMessage(message);
        }
    }

    protected void ruleViolated(BasicValidationRule rule) {
        ValidationMessage oldMessage;
        ValidationMessage message = this.getValidationMessage(rule);
        if (!message.equals(oldMessage = (ValidationMessage)this.validationErrors.get(rule))) {
            this.results.removeMessage(oldMessage);
            this.validationErrors.put(rule, message);
            this.results.addMessage(message);
        }
    }

    protected ValidationMessage getValidationMessage(BasicValidationRule rule) {
        String translatedMessage;
        String field = rule.getField();
        String errorMessage = rule.getErrorMessage();
        String errorKey = rule.getErrorKey();
        if (StringUtils.hasLength((String)errorKey)) {
            Collection errorArgs = rule.getErrorArgs();
            if (errorArgs != null && !errorArgs.isEmpty()) {
                ArrayList<Object> arguments = new ArrayList<Object>();
                Iterator iter = errorArgs.iterator();
                while (iter.hasNext()) {
                    arguments.add(((Function)iter.next()).getResult(this.getSourceObject()));
                }
                translatedMessage = this.getMessageSourceAccessor().getMessage(errorKey, arguments.toArray(), errorMessage);
            } else {
                translatedMessage = this.getMessageSourceAccessor().getMessage(errorKey, errorMessage);
            }
        } else {
            translatedMessage = this.getMessageSourceAccessor().getMessage(field, errorMessage);
        }
        return new DefaultValidationMessage(field, Severity.ERROR, translatedMessage);
    }

    protected Object getSourceObject() {
        return new FormModel2BeanWrapperAdapter();
    }

    private class FormModel2BeanWrapperAdapter
    implements BeanWrapper {
        private FormModel2BeanWrapperAdapter() {
        }

        public Object getPropertyValue(String propertyName) throws BeansException {
            return ValangRichValidator.this.formModel.getValueModel(propertyName).getValue();
        }

        public void setWrappedInstance(Object obj) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Object getWrappedInstance() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Class getWrappedClass() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public PropertyDescriptor[] getPropertyDescriptors() throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Class getPropertyType(String propertyName) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isReadableProperty(String propertyName) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isWritableProperty(String propertyName) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setPropertyValue(String propertyName, Object value) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setPropertyValue(PropertyValue pv) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setPropertyValues(Map map) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setPropertyValues(PropertyValues pvs) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setPropertyValues(PropertyValues propertyValues, boolean ignoreUnknown) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setPropertyValues(PropertyValues propertyValues, boolean ignoreUnknown, boolean ignoreInvalid) throws BeansException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isExtractOldValueForEditor() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Object convertIfNecessary(Object object, Class aClass) throws TypeMismatchException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Object convertIfNecessary(Object object, Class aClass, MethodParameter methodParameter) throws TypeMismatchException {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class PropertiesUsedByRuleCollector {
        private static final ReflectiveVisitorHelper reflectiveVisitorHelper = new ReflectiveVisitorHelper();
        private final BasicValidationRule rule;
        private Set propertiesUsedByRule;

        public PropertiesUsedByRuleCollector(BasicValidationRule rule) {
            this.rule = rule;
        }

        public Set getPropertiesUsedByRule() {
            if (this.propertiesUsedByRule == null) {
                this.propertiesUsedByRule = new HashSet();
                this.doVisit(this.rule.getPredicate());
                Collection errorArgs = this.rule.getErrorArgs();
                if (errorArgs != null && !errorArgs.isEmpty()) {
                    Iterator iter = errorArgs.iterator();
                    while (iter.hasNext()) {
                        this.doVisit(iter.next());
                    }
                }
            }
            return this.propertiesUsedByRule;
        }

        protected void doVisit(Object value) {
            reflectiveVisitorHelper.invokeVisit((Object)this, value);
        }

        void visit(BeanPropertyFunction f) {
            this.propertiesUsedByRule.add(f.getField());
        }

        void visitNull() {
        }

        void visit(Function f) {
        }

        void visit(AbstractFunction f) {
            Function[] arguments = f.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                this.doVisit(arguments[i]);
            }
        }

        void visit(NotPredicate p) {
            Assert.isTrue((p.getPredicates().length == 1 ? 1 : 0) != 0);
            this.doVisit(p.getPredicates()[0]);
        }

        void visit(AndPredicate p) {
            for (int i = 0; i < p.getPredicates().length; ++i) {
                this.doVisit(p.getPredicates()[i]);
            }
        }

        void visit(OrPredicate p) {
            for (int i = 0; i < p.getPredicates().length; ++i) {
                this.doVisit(p.getPredicates()[i]);
            }
        }

        void visit(GenericTestPredicate p) {
            this.doVisit(p.getLeftFunction());
            this.doVisit(p.getRightFunction());
        }

        void visit(MapEntryFunction f) {
            this.doVisit(f.getMapFunction());
            this.doVisit(f.getKeyFunction());
        }

        void visit(AbstractMathFunction f) {
            this.doVisit(f.getLeftFunction());
            this.doVisit(f.getRightFunction());
        }
    }
}

