/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModelAdapter;
import org.springframework.binding.value.swing.ValueCommitPolicy;

public class FormattedTextFieldAdapter
extends AbstractValueModelAdapter
implements PropertyChangeListener,
DocumentListener,
FocusListener {
    private final JFormattedTextField component;
    private boolean settingValue;
    private boolean ignoreValue;

    public FormattedTextFieldAdapter(JFormattedTextField component, ValueModel valueModel, ValueCommitPolicy commitPolicy) {
        super(valueModel);
        this.component = component;
        this.component.setFocusLostBehavior(1);
        this.component.addPropertyChangeListener("value", this);
        if (commitPolicy == ValueCommitPolicy.AS_YOU_TYPE) {
            component.getDocument().addDocumentListener(this);
        }
        component.addFocusListener(this);
        this.initalizeAdaptedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void valueModelValueChanged(Object value) {
        this.settingValue = true;
        try {
            this.component.setValue(value);
        }
        finally {
            this.settingValue = false;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (logger.isDebugEnabled()) {
            Class<?> valueClass = e.getNewValue() != null ? e.getNewValue().getClass() : null;
            logger.debug((Object)("Formatted text field property '" + e.getPropertyName() + "' changed; new value is '" + e.getNewValue() + "', valueClass=" + valueClass));
        }
        this.adaptedValueChanged(this.component.getValue());
    }

    public void insertUpdate(DocumentEvent e) {
        this.tryToCommitEdit();
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.ignoreValue) {
            this.tryToCommitEdit();
        } else {
            this.ignoreValue = false;
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.tryToCommitEdit();
    }

    private void tryToCommitEdit() {
        if (!this.settingValue) {
            try {
                this.component.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void focusGained(FocusEvent e) {
        this.ignoreValue = false;
    }

    public void focusLost(FocusEvent e) {
        this.ignoreValue = true;
    }
}

