/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.AbstractConverter;
import org.springframework.binding.convert.support.AbstractFormattingConverter;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.format.FormatterFactory;
import org.springframework.binding.format.support.StrictNumberFormatterFactory;
import org.springframework.richclient.convert.support.CollectionConverter;
import org.springframework.richclient.convert.support.ListModelConverter;
import org.springframework.util.StringUtils;

public class DefaultConversionServiceFactoryBean
implements FactoryBean {
    private ConversionService conversionService;
    private FormatterFactory formatterFactory = new StrictNumberFormatterFactory();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;

    protected FormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public void setFormatterFactory(FormatterFactory formatterFactory) {
        this.formatterFactory = formatterFactory;
    }

    public Object getObject() throws Exception {
        return this.getConversionService();
    }

    public Class getObjectType() {
        return ConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public final ConversionService getConversionService() {
        if (this.conversionService == null) {
            this.conversionService = this.createConversionService();
        }
        return this.conversionService;
    }

    protected ConversionService createConversionService() {
        DefaultConversionService service = new DefaultConversionService();
        service.addConverter((Converter)new TextToDate(this.getFormatterFactory(), true));
        service.addConverter((Converter)new DateToText(this.getFormatterFactory(), true));
        service.addConverter((Converter)new TextToNumber(this.getFormatterFactory(), true));
        service.addConverter((Converter)new NumberToText(this.getFormatterFactory(), true));
        service.addConverter((Converter)new BooleanToText());
        service.addConverter((Converter)new TextToBoolean());
        service.addConverter((Converter)new CollectionConverter());
        service.addConverter((Converter)new ListModelConverter());
        return service;
    }

    static final class BooleanToText
    extends AbstractConverter {
        public static final String VALUE_YES = "yes";
        public static final String VALUE_NO = "no";
        private String trueString;
        private String falseString;

        public BooleanToText() {
        }

        public BooleanToText(String trueString, String falseString) {
            this.trueString = trueString;
            this.falseString = falseString;
        }

        public Class[] getSourceClasses() {
            return new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultConversionServiceFactoryBean.class$("java.lang.Boolean")) : class$java$lang$Boolean};
        }

        public Class[] getTargetClasses() {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConversionServiceFactoryBean.class$("java.lang.String")) : class$java$lang$String};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            Boolean bool = (Boolean)source;
            if (this.trueString != null && bool.booleanValue()) {
                return this.trueString;
            }
            if (this.falseString != null && !bool.booleanValue()) {
                return this.falseString;
            }
            if (bool.booleanValue()) {
                return VALUE_YES;
            }
            return VALUE_NO;
        }
    }

    static final class TextToBoolean
    extends AbstractConverter {
        public static final String VALUE_TRUE = "true";
        public static final String VALUE_FALSE = "false";
        public static final String VALUE_ON = "on";
        public static final String VALUE_OFF = "off";
        public static final String VALUE_YES = "yes";
        public static final String VALUE_NO = "no";
        public static final String VALUE_1 = "1";
        public static final String VALUE_0 = "0";
        private String trueString;
        private String falseString;

        public TextToBoolean() {
        }

        public TextToBoolean(String trueString, String falseString) {
            this.trueString = trueString;
            this.falseString = falseString;
        }

        public Class[] getSourceClasses() {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConversionServiceFactoryBean.class$("java.lang.String")) : class$java$lang$String};
        }

        public Class[] getTargetClasses() {
            return new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultConversionServiceFactoryBean.class$("java.lang.Boolean")) : class$java$lang$Boolean};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            String text = (String)source;
            if (!StringUtils.hasText((String)text)) {
                return null;
            }
            if (this.trueString != null && text.equalsIgnoreCase(this.trueString)) {
                return Boolean.TRUE;
            }
            if (this.falseString != null && text.equalsIgnoreCase(this.falseString)) {
                return Boolean.FALSE;
            }
            if (this.trueString == null && (text.equalsIgnoreCase(VALUE_TRUE) || text.equalsIgnoreCase(VALUE_ON) || text.equalsIgnoreCase(VALUE_YES) || text.equals(VALUE_1))) {
                return Boolean.TRUE;
            }
            if (this.falseString == null && (text.equalsIgnoreCase(VALUE_FALSE) || text.equalsIgnoreCase(VALUE_OFF) || text.equalsIgnoreCase(VALUE_NO) || text.equals(VALUE_0))) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
        }
    }

    static final class NumberToText
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected NumberToText(FormatterFactory formatterLocator, boolean allowEmpty) {
            super(formatterLocator);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultConversionServiceFactoryBean.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = DefaultConversionServiceFactoryBean.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultConversionServiceFactoryBean.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = DefaultConversionServiceFactoryBean.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = DefaultConversionServiceFactoryBean.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = DefaultConversionServiceFactoryBean.class$("java.lang.Double")) : class$java$lang$Double, class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultConversionServiceFactoryBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultConversionServiceFactoryBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal};
        }

        public Class[] getTargetClasses() {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConversionServiceFactoryBean.class$("java.lang.String")) : class$java$lang$String};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || source != null ? this.getFormatterFactory().getNumberFormatter(source.getClass()).formatValue(source) : "";
        }
    }

    static final class TextToNumber
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected TextToNumber(FormatterFactory formatterLocator, boolean allowEmpty) {
            super(formatterLocator);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConversionServiceFactoryBean.class$("java.lang.String")) : class$java$lang$String};
        }

        public Class[] getTargetClasses() {
            return new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultConversionServiceFactoryBean.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = DefaultConversionServiceFactoryBean.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultConversionServiceFactoryBean.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = DefaultConversionServiceFactoryBean.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = DefaultConversionServiceFactoryBean.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = DefaultConversionServiceFactoryBean.class$("java.lang.Double")) : class$java$lang$Double, class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultConversionServiceFactoryBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultConversionServiceFactoryBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || StringUtils.hasText((String)((String)source)) ? this.getFormatterFactory().getNumberFormatter(targetClass).parseValue((String)source, targetClass) : null;
        }
    }

    static final class DateToText
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected DateToText(FormatterFactory formatterLocator, boolean allowEmpty) {
            super(formatterLocator);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{class$java$util$Date == null ? (class$java$util$Date = DefaultConversionServiceFactoryBean.class$("java.util.Date")) : class$java$util$Date};
        }

        public Class[] getTargetClasses() {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConversionServiceFactoryBean.class$("java.lang.String")) : class$java$lang$String};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || source != null ? this.getFormatterFactory().getDateTimeFormatter().formatValue(source) : "";
        }
    }

    static final class TextToDate
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected TextToDate(FormatterFactory formatterFactory, boolean allowEmpty) {
            super(formatterFactory);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConversionServiceFactoryBean.class$("java.lang.String")) : class$java$lang$String};
        }

        public Class[] getTargetClasses() {
            return new Class[]{class$java$util$Date == null ? (class$java$util$Date = DefaultConversionServiceFactoryBean.class$("java.util.Date")) : class$java$util$Date};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || StringUtils.hasText((String)((String)source)) ? this.getFormatterFactory().getDateTimeFormatter().parseValue((String)source, class$java$util$Date == null ? (class$java$util$Date = DefaultConversionServiceFactoryBean.class$("java.util.Date")) : class$java$util$Date) : null;
        }
    }
}

