/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.config;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationServices;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.config.ApplicationWindowConfigurer;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.application.statusbar.support.DefaultStatusBar;
import org.springframework.richclient.application.support.ApplicationWindowCommandManager;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.exceptionhandling.DefaultRegisterableExceptionHandler;
import org.springframework.richclient.exceptionhandling.RegisterableExceptionHandler;

public abstract class ApplicationLifecycleAdvisor
implements InitializingBean {
    private Application application;
    private ApplicationWindow openingWindow;
    private String startingPageId;
    private RegisterableExceptionHandler registerableExceptionHandler;

    public void setStartingPageId(String pageDescriptorId) {
        this.startingPageId = pageDescriptorId;
    }

    public void setRegisterableExceptionHandler(RegisterableExceptionHandler registerableExceptionHandler) {
        this.registerableExceptionHandler = registerableExceptionHandler;
    }

    public void afterPropertiesSet() throws Exception {
        this.getRegisterableExceptionHandler().registerExceptionHandler();
    }

    public String getStartingPageId() {
        return this.startingPageId;
    }

    protected Application getApplication() {
        return this.application;
    }

    protected ApplicationServices getApplicationServices() {
        return ApplicationServicesLocator.services();
    }

    public void onPreInitialize(Application application) {
    }

    public void onPreStartup() {
    }

    public void onPostStartup() {
    }

    public void onShutdown() {
    }

    public void setOpeningWindow(ApplicationWindow window) {
        this.openingWindow = window;
    }

    public void onPreWindowOpen(ApplicationWindowConfigurer configurer) {
        configurer.setTitle(this.getApplication().getName());
        configurer.setImage(this.getApplication().getImage());
    }

    protected final ApplicationWindow getOpeningWindow() {
        return this.openingWindow;
    }

    public ApplicationWindowCommandManager createWindowCommandManager() {
        return new ApplicationWindowCommandManager();
    }

    public CommandGroup getMenuBarCommandGroup() {
        return new CommandGroup();
    }

    public CommandGroup getToolBarCommandGroup() {
        return new CommandGroup();
    }

    public StatusBar getStatusBar() {
        return new DefaultStatusBar();
    }

    public void onCommandsCreated(ApplicationWindow window) {
    }

    public void onWindowCreated(ApplicationWindow window) {
    }

    public void onWindowOpened(ApplicationWindow window) {
    }

    public boolean onPreWindowClose(ApplicationWindow window) {
        return true;
    }

    public RegisterableExceptionHandler getRegisterableExceptionHandler() {
        if (this.registerableExceptionHandler == null) {
            this.registerableExceptionHandler = new DefaultRegisterableExceptionHandler();
        }
        return this.registerableExceptionHandler;
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

