/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.config.ApplicationLifecycleAdvisor;
import org.springframework.richclient.application.config.ApplicationWindowSetter;
import org.springframework.richclient.application.support.ApplicationWindowCommandManager;
import org.springframework.richclient.command.CommandGroup;

public class DefaultApplicationLifecycleAdvisor
extends ApplicationLifecycleAdvisor
implements ApplicationListener {
    private String windowCommandManagerBeanName;
    private String toolBarBeanName;
    private String menuBarBeanName;
    private String windowCommandBarDefinitions;
    private ConfigurableListableBeanFactory openingWindowCommandBarFactory;
    private ArrayList childContexts = new ArrayList();

    public void setWindowCommandBarDefinitions(String commandBarDefinitionLocation) {
        this.windowCommandBarDefinitions = commandBarDefinitionLocation;
    }

    public void setWindowCommandManagerBeanName(String commandManagerBeanName) {
        this.windowCommandManagerBeanName = commandManagerBeanName;
    }

    public void setMenubarBeanName(String menubarBeanName) {
        this.menuBarBeanName = menubarBeanName;
    }

    public void setToolbarBeanName(String toolbarBeanName) {
        this.toolBarBeanName = toolbarBeanName;
    }

    public ApplicationWindowCommandManager createWindowCommandManager() {
        this.initNewWindowCommandBarFactory();
        if (this.windowCommandManagerBeanName == null || !this.getCommandBarFactory().containsBean(this.windowCommandManagerBeanName)) {
            return new ApplicationWindowCommandManager();
        }
        return (ApplicationWindowCommandManager)this.getCommandBarFactory().getBean(this.windowCommandManagerBeanName, ApplicationWindowCommandManager.class);
    }

    protected void initNewWindowCommandBarFactory() {
        if (this.windowCommandBarDefinitions != null) {
            CommandBarApplicationContext commandBarContext = new CommandBarApplicationContext(this.windowCommandBarDefinitions);
            this.addChildCommandContext((ApplicationContext)commandBarContext);
            this.openingWindowCommandBarFactory = commandBarContext.getBeanFactory();
        } else {
            this.openingWindowCommandBarFactory = new DefaultListableBeanFactory();
        }
    }

    protected ConfigurableListableBeanFactory getCommandBarFactory() {
        return this.openingWindowCommandBarFactory;
    }

    public CommandGroup getMenuBarCommandGroup() {
        CommandGroup menuBarCommandGroup = this.getCommandGroup(this.menuBarBeanName);
        return menuBarCommandGroup != null ? menuBarCommandGroup : super.getMenuBarCommandGroup();
    }

    public CommandGroup getToolBarCommandGroup() {
        CommandGroup toolBarCommandGroup = this.getCommandGroup(this.toolBarBeanName);
        return toolBarCommandGroup != null ? toolBarCommandGroup : super.getToolBarCommandGroup();
    }

    protected CommandGroup getCommandGroup(String name) {
        if (name == null || !this.getCommandBarFactory().containsBean(name)) {
            return null;
        }
        return (CommandGroup)this.getCommandBarFactory().getBean(name);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Iterator iter = this.getChildCommandContexts().iterator();
        while (iter.hasNext()) {
            ApplicationContext ctx = (ApplicationContext)iter.next();
            ctx.publishEvent(event);
        }
    }

    protected List getChildCommandContexts() {
        return this.childContexts;
    }

    protected void addChildCommandContext(ApplicationContext context) {
        this.childContexts.add(context);
    }

    private class CommandBarApplicationContext
    extends ClassPathXmlApplicationContext {
        public CommandBarApplicationContext(String location) {
            super(new String[]{location}, false, Application.instance().getApplicationContext());
            this.refresh();
        }

        protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new ApplicationWindowSetter(DefaultApplicationLifecycleAdvisor.this.getOpeningWindow()));
        }

        public void publishEvent(ApplicationEvent event) {
            ApplicationContext parent = this.getParent();
            this.setParent(null);
            super.publishEvent(event);
            this.setParent(parent);
        }
    }
}

