/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.core.closure.support.AbstractConstraint;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageComponentDescriptor;
import org.springframework.richclient.application.PageComponentListener;
import org.springframework.richclient.application.PageComponentPane;
import org.springframework.richclient.application.PageComponentPaneFactory;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.View;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.ViewDescriptorRegistry;
import org.springframework.richclient.application.support.DefaultViewContext;
import org.springframework.richclient.application.support.SharedCommandTargeter;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.util.Assert;

public abstract class AbstractApplicationPage
extends AbstractControlFactory
implements ApplicationPage {
    private final EventListenerListHelper pageComponentListeners = new EventListenerListHelper(PageComponentListener.class);
    private final ViewDescriptorRegistry viewDescriptorRegistry = (ViewDescriptorRegistry)ApplicationServicesLocator.services().getService(ViewDescriptorRegistry.class);
    private final Set pageComponents = new LinkedHashSet();
    private PageComponent activeComponent;
    private SharedCommandTargeter sharedCommandTargeter;
    private PageDescriptor descriptor;
    private ApplicationWindow window;
    private boolean settingActiveComponent;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private PropertyChangeListener pageComponentUpdater = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof PageComponent) {
                AbstractApplicationPage.this.updatePageComponentProperties((PageComponent)evt.getSource());
            }
        }
    };

    public AbstractApplicationPage() {
    }

    public AbstractApplicationPage(ApplicationWindow window, PageDescriptor pageDescriptor) {
        this.setApplicationWindow(window);
        this.setDescriptor(pageDescriptor);
    }

    protected void updatePageComponentProperties(PageComponent pageComponent) {
    }

    protected PageComponent findPageComponent(final String viewDescriptorId) {
        return (PageComponent)new AbstractConstraint(){

            public boolean test(Object arg) {
                if (arg instanceof View) {
                    return ((View)arg).getId().equals(viewDescriptorId);
                }
                return false;
            }
        }.findFirst((Collection)this.pageComponents);
    }

    public void addPageComponentListener(PageComponentListener listener) {
        this.pageComponentListeners.add((Object)listener);
    }

    public void removePageComponentListener(PageComponentListener listener) {
        this.pageComponentListeners.remove((Object)listener);
    }

    protected void fireOpened(PageComponent component) {
        component.componentOpened();
        this.pageComponentListeners.fire("componentOpened", (Object)component);
    }

    protected void fireFocusGained(PageComponent component) {
        component.componentFocusGained();
        this.pageComponentListeners.fire("componentFocusGained", (Object)component);
    }

    protected void setActiveComponent() {
        if (this.pageComponents.size() > 0) {
            this.setActiveComponent((PageComponent)this.pageComponents.iterator().next());
        }
    }

    protected ViewDescriptor getViewDescriptor(String viewDescriptorId) {
        return this.viewDescriptorRegistry.getViewDescriptor(viewDescriptorId);
    }

    public PageComponent getActiveComponent() {
        return this.activeComponent;
    }

    public void setActiveComponent(PageComponent pageComponent) {
        if (!this.pageComponents.contains(pageComponent)) {
            return;
        }
        if (this.activeComponent == pageComponent || this.settingActiveComponent) {
            return;
        }
        this.settingActiveComponent = true;
        if (this.activeComponent != null) {
            this.fireFocusLost(this.activeComponent);
        }
        this.giveFocusTo(pageComponent);
        this.activeComponent = pageComponent;
        this.fireFocusGained(this.activeComponent);
        this.settingActiveComponent = false;
    }

    protected void fireFocusLost(PageComponent component) {
        component.componentFocusLost();
        this.pageComponentListeners.fire("componentFocusLost", (Object)component);
    }

    protected abstract void doAddPageComponent(PageComponent var1);

    protected abstract void doRemovePageComponent(PageComponent var1);

    protected abstract boolean giveFocusTo(PageComponent var1);

    protected PageComponentPane createPageComponentPane(PageComponent pageComponent) {
        PageComponentPaneFactory paneFactory = (PageComponentPaneFactory)Application.services().getService(PageComponentPaneFactory.class);
        return paneFactory.createPageComponentPane(pageComponent);
    }

    protected void fireClosed(PageComponent component) {
        component.componentClosed();
        this.pageComponentListeners.fire("componentClosed", (Object)component);
    }

    public String getId() {
        return this.descriptor.getId();
    }

    public ApplicationWindow getWindow() {
        return this.window;
    }

    public boolean close(PageComponent pageComponent) {
        if (!pageComponent.canClose()) {
            return false;
        }
        if (!this.pageComponents.contains(pageComponent)) {
            return false;
        }
        if (pageComponent == this.activeComponent) {
            this.fireFocusLost(pageComponent);
            this.activeComponent = null;
        }
        this.pageComponents.remove(pageComponent);
        this.doRemovePageComponent(pageComponent);
        pageComponent.removePropertyChangeListener(this.pageComponentUpdater);
        if (pageComponent instanceof ApplicationListener && this.getApplicationEventMulticaster() != null) {
            this.getApplicationEventMulticaster().removeApplicationListener((ApplicationListener)pageComponent);
        }
        pageComponent.dispose();
        this.fireClosed(pageComponent);
        if (this.activeComponent == null) {
            this.setActiveComponent();
        }
        return true;
    }

    public boolean close() {
        Iterator iter = new HashSet(this.pageComponents).iterator();
        while (iter.hasNext()) {
            PageComponent component = (PageComponent)iter.next();
            if (this.close(component)) continue;
            return false;
        }
        return true;
    }

    public void showView(String viewDescriptorId) {
        this.showView(this.getViewDescriptor(viewDescriptorId));
    }

    public void showView(ViewDescriptor viewDescriptor) {
        PageComponent component = this.findPageComponent(viewDescriptor.getId());
        if (component == null) {
            component = this.createPageComponent(viewDescriptor);
            this.addPageComponent(component);
        }
        this.setActiveComponent(component);
    }

    public void openEditor(Object editorInput) {
    }

    public boolean closeAllEditors() {
        return true;
    }

    protected void addPageComponent(PageComponent pageComponent) {
        this.pageComponents.add(pageComponent);
        this.doAddPageComponent(pageComponent);
        pageComponent.addPropertyChangeListener(this.pageComponentUpdater);
        this.fireOpened(pageComponent);
    }

    protected PageComponent createPageComponent(PageComponentDescriptor descriptor) {
        PageComponent pageComponent = descriptor.createPageComponent();
        pageComponent.setContext(new DefaultViewContext(this, this.createPageComponentPane(pageComponent)));
        if (pageComponent instanceof ApplicationListener && this.getApplicationEventMulticaster() != null) {
            this.getApplicationEventMulticaster().addApplicationListener((ApplicationListener)pageComponent);
        }
        return pageComponent;
    }

    public Set getPageComponents() {
        return Collections.unmodifiableSet(this.pageComponents);
    }

    public final void setApplicationWindow(ApplicationWindow window) {
        Assert.notNull((Object)window, (String)"The containing window is required");
        Assert.state((this.window == null ? 1 : 0) != 0, (String)"Page window already set: it should only be set once, during initialization");
        this.window = window;
        this.sharedCommandTargeter = new SharedCommandTargeter(window);
        this.addPageComponentListener(this.sharedCommandTargeter);
    }

    public final void setDescriptor(PageDescriptor descriptor) {
        Assert.notNull((Object)descriptor, (String)"The page's descriptor is required");
        Assert.state((this.descriptor == null ? 1 : 0) != 0, (String)"Page descriptor already set: it should only be set once, during initialization");
        this.descriptor = descriptor;
    }

    protected PageDescriptor getPageDescriptor() {
        return this.descriptor;
    }

    public ApplicationEventMulticaster getApplicationEventMulticaster() {
        if (this.applicationEventMulticaster == null && this.getApplicationContext() != null) {
            String beanName = "applicationEventMulticaster";
            if (this.getApplicationContext().containsBean("applicationEventMulticaster")) {
                this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getApplicationContext().getBean("applicationEventMulticaster");
            }
        }
        return this.applicationEventMulticaster;
    }
}

