/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.ApplicationPageFactory;
import org.springframework.richclient.application.ApplicationServices;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.PageListener;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.WindowManager;
import org.springframework.richclient.application.config.ApplicationLifecycleAdvisor;
import org.springframework.richclient.application.config.ApplicationWindowConfigurer;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.application.support.ApplicationWindowCommandManager;
import org.springframework.richclient.application.support.DefaultApplicationWindowConfigurer;
import org.springframework.richclient.application.support.SingleViewPageDescriptor;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandManager;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.richclient.util.WindowUtils;
import org.springframework.util.Assert;

public abstract class AbstractApplicationWindow
implements ApplicationWindow,
WindowFocusListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final EventListenerListHelper pageListeners = new EventListenerListHelper(PageListener.class);
    private int number;
    private ApplicationWindowCommandManager commandManager;
    private CommandGroup menuBarCommandGroup;
    private CommandGroup toolBarCommandGroup;
    private StatusBar statusBar;
    private ApplicationWindowConfigurer windowConfigurer;
    private JFrame control;
    private ApplicationPage currentPage;
    private WindowManager windowManager;

    public AbstractApplicationWindow() {
        this(Application.instance().getWindowManager().size());
    }

    public AbstractApplicationWindow(int number) {
        this.number = number;
        this.getAdvisor().setOpeningWindow(this);
        this.init();
        this.getAdvisor().onCommandsCreated(this);
    }

    protected void init() {
        this.commandManager = this.getAdvisor().createWindowCommandManager();
        this.menuBarCommandGroup = this.getAdvisor().getMenuBarCommandGroup();
        this.toolBarCommandGroup = this.getAdvisor().getToolBarCommandGroup();
        this.statusBar = this.getAdvisor().getStatusBar();
    }

    public int getNumber() {
        return this.number;
    }

    public ApplicationPage getPage() {
        return this.currentPage;
    }

    protected ApplicationLifecycleAdvisor getAdvisor() {
        return Application.instance().getLifecycleAdvisor();
    }

    protected ApplicationServices getServices() {
        return ApplicationServicesLocator.services();
    }

    protected ApplicationWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = this.initWindowConfigurer();
        }
        return this.windowConfigurer;
    }

    protected ApplicationWindowConfigurer initWindowConfigurer() {
        return new DefaultApplicationWindowConfigurer(this);
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Iterator getSharedCommands() {
        return this.commandManager.getSharedCommands();
    }

    public CommandGroup getMenuBar() {
        return this.menuBarCommandGroup;
    }

    public CommandGroup getToolBar() {
        return this.toolBarCommandGroup;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public void showPage(String pageId) {
        if (pageId == null) {
            throw new IllegalArgumentException("pageId == null");
        }
        if (this.getPage() == null || !this.getPage().getId().equals(pageId)) {
            this.showPage(this.createPage(this, pageId));
        }
    }

    public void showPage(PageDescriptor pageDescriptor) {
        Assert.notNull((Object)pageDescriptor, (String)"pageDescriptor == null");
        if (this.getPage() == null || !this.getPage().getId().equals(pageDescriptor.getId())) {
            this.showPage(this.createPage(pageDescriptor));
        }
    }

    public void showPage(ApplicationPage page) {
        if (page == null) {
            throw new IllegalArgumentException("page == null");
        }
        if (this.currentPage == null) {
            this.currentPage = page;
            this.getAdvisor().onPreWindowOpen(this.getWindowConfigurer());
            this.control = this.createNewWindowControl();
            this.control.addWindowFocusListener(this);
            this.initWindowControl(this.control);
            this.getAdvisor().onWindowCreated(this);
            this.setActivePage(page);
            this.control.setVisible(true);
            this.getAdvisor().onWindowOpened(this);
        } else if (!this.currentPage.getId().equals(page.getId())) {
            ApplicationPage oldPage = this.currentPage;
            this.currentPage = page;
            this.setActivePage(page);
            this.pageListeners.fire("pageClosed", (Object)oldPage);
        }
        this.pageListeners.fire("pageOpened", (Object)this.currentPage);
    }

    protected final ApplicationPage createPage(ApplicationWindow window, String pageDescriptorId) {
        PageDescriptor descriptor = this.getPageDescriptor(pageDescriptorId);
        return this.createPage(descriptor);
    }

    protected ApplicationPage createPage(PageDescriptor descriptor) {
        ApplicationPageFactory windowFactory = (ApplicationPageFactory)this.getServices().getService(ApplicationPageFactory.class);
        return windowFactory.createApplicationPage(this, descriptor);
    }

    protected PageDescriptor getPageDescriptor(String pageDescriptorId) {
        ApplicationContext ctx = Application.instance().getApplicationContext();
        Assert.state((boolean)ctx.containsBean(pageDescriptorId), (String)("Do not know about page or view descriptor with name '" + pageDescriptorId + "' - check your context config"));
        Object desc = ctx.getBean(pageDescriptorId);
        if (desc instanceof PageDescriptor) {
            return (PageDescriptor)desc;
        }
        if (desc instanceof ViewDescriptor) {
            return new SingleViewPageDescriptor((ViewDescriptor)desc);
        }
        throw new IllegalArgumentException("Page id '" + pageDescriptorId + "' is not backed by an ApplicationPageDescriptor");
    }

    protected void initWindowControl(JFrame windowControl) {
        ApplicationWindowConfigurer configurer = this.getWindowConfigurer();
        this.applyStandardLayout(windowControl, configurer);
        this.prepareWindowForView(windowControl, configurer);
    }

    protected void applyStandardLayout(JFrame windowControl, ApplicationWindowConfigurer configurer) {
        windowControl.setTitle(configurer.getTitle());
        windowControl.setIconImage(configurer.getImage());
        windowControl.setJMenuBar(this.createMenuBarControl());
        windowControl.getContentPane().setLayout(new BorderLayout());
        windowControl.getContentPane().add((Component)this.createToolBarControl(), "North");
        windowControl.getContentPane().add(this.createWindowContentPane());
        windowControl.getContentPane().add((Component)this.createStatusBarControl(), "South");
    }

    protected abstract void setActivePage(ApplicationPage var1);

    protected void prepareWindowForView(JFrame windowControl, ApplicationWindowConfigurer configurer) {
        windowControl.pack();
        windowControl.setSize(configurer.getInitialSize());
        WindowUtils.centerOnScreen(windowControl);
    }

    protected JFrame createNewWindowControl() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(0);
        WindowAdapter windowCloseHandler = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractApplicationWindow.this.close();
            }
        };
        frame.addWindowListener(windowCloseHandler);
        return frame;
    }

    public JFrame getControl() {
        return this.control;
    }

    public boolean isControlCreated() {
        return this.control != null;
    }

    protected JMenuBar createMenuBarControl() {
        JMenuBar menuBar = this.menuBarCommandGroup.createMenuBar();
        this.menuBarCommandGroup.setVisible(this.getWindowConfigurer().getShowMenuBar());
        return menuBar;
    }

    protected JComponent createToolBarControl() {
        JComponent toolBar = this.toolBarCommandGroup.createToolBar();
        this.toolBarCommandGroup.setVisible(this.getWindowConfigurer().getShowToolBar());
        return toolBar;
    }

    protected JComponent createStatusBarControl() {
        JComponent statusBarControl = this.statusBar.getControl();
        statusBarControl.setVisible(this.getWindowConfigurer().getShowStatusBar());
        return statusBarControl;
    }

    public void addPageListener(PageListener listener) {
        this.pageListeners.add((Object)listener);
    }

    public void removePageListener(PageListener listener) {
        this.pageListeners.remove((Object)listener);
    }

    public boolean close() {
        boolean canClose = this.getAdvisor().onPreWindowClose(this);
        if (canClose) {
            if (this.currentPage != null && !(canClose = this.currentPage.close())) {
                return canClose;
            }
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
            if (this.windowManager != null) {
                this.windowManager.remove(this);
            }
            this.windowManager = null;
        }
        return canClose;
    }

    public void windowGainedFocus(WindowEvent e) {
        if (this.windowManager != null) {
            this.windowManager.setActiveWindow(this);
        }
    }

    public void windowLostFocus(WindowEvent e) {
    }

    protected abstract JComponent createWindowContentPane();
}

