/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationServices;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.image.ImageSource;

public class ApplicationServicesAccessor {
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected String getApplicationName() {
        return this.getApplication().getName();
    }

    protected Application getApplication() {
        return Application.instance();
    }

    protected ApplicationServices getApplicationServices() {
        return ApplicationServicesLocator.services();
    }

    protected Object getService(Class serviceType) {
        return this.getApplicationServices().getService(serviceType);
    }

    protected ApplicationContext getApplicationContext() {
        return this.getApplication().getApplicationContext();
    }

    protected ComponentFactory getComponentFactory() {
        return (ComponentFactory)this.getService(ComponentFactory.class);
    }

    protected MessageSource getMessageSource() {
        return this.getApplicationContext();
    }

    protected MessageSourceAccessor getMessages() {
        return (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
    }

    protected ImageSource getImageSource() {
        return (ImageSource)this.getService(ImageSource.class);
    }

    protected IconSource getIconSource() {
        return (IconSource)this.getService(IconSource.class);
    }

    protected ApplicationObjectConfigurer getObjectConfigurer() {
        return (ApplicationObjectConfigurer)this.getService(ApplicationObjectConfigurer.class);
    }

    protected CommandConfigurer getCommandConfigurer() {
        return (CommandConfigurer)this.getService(CommandConfigurer.class);
    }

    protected ApplicationWindow getActiveWindow() {
        return this.getApplication().getActiveWindow();
    }

    protected ConversionService getConversionService() {
        return (ConversionService)this.getService(ConversionService.class);
    }

    protected String getMessage(String messageCode) {
        return this.getApplicationContext().getMessage(messageCode, null, messageCode, Locale.getDefault());
    }

    protected String getMessage(final String[] messageCodes) {
        MessageSourceResolvable resolvable = new MessageSourceResolvable(){

            public String[] getCodes() {
                return messageCodes;
            }

            public Object[] getArguments() {
                return new Object[0];
            }

            public String getDefaultMessage() {
                return messageCodes[0];
            }
        };
        return this.getApplicationContext().getMessage(resolvable, Locale.getDefault());
    }

    protected String getMessage(String messageCode, Object[] args) {
        return this.getApplicationContext().getMessage(messageCode, args, messageCode, Locale.getDefault());
    }

    protected String getMessage(final String[] messageCodes, final Object[] args) {
        MessageSourceResolvable resolvable = new MessageSourceResolvable(){

            public String[] getCodes() {
                return messageCodes;
            }

            public Object[] getArguments() {
                return args;
            }

            public String getDefaultMessage() {
                return messageCodes[0];
            }
        };
        return this.getApplicationContext().getMessage(resolvable, Locale.getDefault());
    }
}

