/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageComponentPane;
import org.springframework.richclient.control.SimpleInternalFrame;
import org.springframework.richclient.factory.AbstractControlFactory;

public class DefaultPageComponentPane
extends AbstractControlFactory
implements PageComponentPane {
    private PageComponent component;
    private PropertyChangeListener updater = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            DefaultPageComponentPane.this.handleViewPropertyChange();
        }
    };

    public DefaultPageComponentPane(PageComponent component) {
        this.component = component;
        this.component.addPropertyChangeListener(this.updater);
    }

    public PageComponent getPageComponent() {
        return this.component;
    }

    protected JComponent createControl() {
        return new SimpleInternalFrame(this.component.getIcon(), this.component.getDisplayName(), this.createViewToolBar(), this.component.getControl());
    }

    protected JToolBar createViewToolBar() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.handleViewPropertyChange();
    }

    protected void handleViewPropertyChange() {
        SimpleInternalFrame frame = (SimpleInternalFrame)this.getControl();
        frame.setTitle(this.component.getDisplayName());
        frame.setFrameIcon(this.component.getIcon());
        frame.setToolTipText(this.component.getCaption());
    }
}

