/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.HashMap;
import java.util.Map;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponentPane;
import org.springframework.richclient.application.ViewContext;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.util.Assert;

public class DefaultViewContext
implements ViewContext {
    private PageComponentPane pane;
    private ApplicationPage page;
    private Map sharedCommandExecutors;

    public DefaultViewContext(ApplicationPage page, PageComponentPane pane) {
        Assert.notNull((Object)page, (String)"Views must be scoped relative to a page");
        this.page = page;
        this.pane = pane;
    }

    public ApplicationWindow getWindow() {
        return this.page.getWindow();
    }

    public ApplicationPage getPage() {
        return this.page;
    }

    public PageComponentPane getPane() {
        return this.pane;
    }

    public ActionCommandExecutor getLocalCommandExecutor(String commandId) {
        Assert.notNull((Object)commandId, (String)"The commandId is required");
        if (this.sharedCommandExecutors == null) {
            return null;
        }
        return (ActionCommandExecutor)this.sharedCommandExecutors.get(commandId);
    }

    public void register(String commandId, ActionCommandExecutor executor) {
        Assert.notNull((Object)commandId, (String)"The command id is required");
        if (this.sharedCommandExecutors == null) {
            this.sharedCommandExecutors = new HashMap();
        }
        if (executor == null) {
            this.sharedCommandExecutors.remove(commandId);
        } else {
            this.sharedCommandExecutors.put(commandId, executor);
        }
    }
}

