/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Window;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JFrame;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.util.WindowUtils;

public class HelpContents {
    private Resource helpSetPath = new ClassPathResource("help/helpset.hs");
    private JFrame helpFrame;

    public void setHelpSetPath(Resource helpSetPath) {
        this.helpSetPath = helpSetPath;
    }

    protected String getApplicationName() {
        return Application.instance().getName();
    }

    protected Image getApplicationImage() {
        return Application.instance().getImage();
    }

    public void display(Window parent) {
        if (this.helpFrame == null) {
            this.helpFrame = new JFrame();
            this.helpFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            try {
                HelpSet helpSet = new HelpSet(null, this.helpSetPath.getURL());
                JHelp jhelp = new JHelp(helpSet);
                this.helpFrame = new JFrame("Help - " + this.getApplicationName());
                this.helpFrame.getContentPane().add((Component)jhelp);
                this.helpFrame.setIconImage(this.getApplicationImage());
                this.helpFrame.pack();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.helpFrame.getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        if (!this.helpFrame.isVisible()) {
            WindowUtils.centerOnParent(this.helpFrame, parent);
            this.helpFrame.setVisible(true);
        }
        if ((this.helpFrame.getExtendedState() & 0) == 0) {
            this.helpFrame.setExtendedState(0);
        }
        this.helpFrame.toFront();
    }
}

