/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.Iterator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageComponentContext;
import org.springframework.richclient.application.support.PageComponentListenerAdapter;
import org.springframework.richclient.command.TargetableActionCommand;
import org.springframework.util.Assert;

public class SharedCommandTargeter
extends PageComponentListenerAdapter {
    private ApplicationWindow window;

    public SharedCommandTargeter(ApplicationWindow window) {
        Assert.notNull((Object)window, (String)"The application window containing targetable shared commands is required");
        this.window = window;
    }

    public void componentFocusGained(PageComponent component) {
        super.componentFocusGained(component);
        PageComponentContext context = component.getContext();
        Iterator i = this.window.getSharedCommands();
        while (i.hasNext()) {
            TargetableActionCommand globalCommand = (TargetableActionCommand)i.next();
            globalCommand.setCommandExecutor(context.getLocalCommandExecutor(globalCommand.getId()));
        }
    }
}

