/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.value.support.AbstractPropertyChangePublisher;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandServices;
import org.springframework.richclient.command.GuardedActionCommandExecutor;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandButtonIconInfo;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.command.config.CommandFaceDescriptorRegistry;
import org.springframework.richclient.command.support.CommandFaceButtonManager;
import org.springframework.richclient.core.SecurityControllable;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.StringUtils;

public abstract class AbstractCommand
extends AbstractPropertyChangePublisher
implements InitializingBean,
BeanNameAware,
GuardedActionCommandExecutor,
SecurityControllable {
    public static final String ENABLED_PROPERTY_NAME = "enabled";
    public static final String VISIBLE_PROPERTY_NAME = "visible";
    private static final String DEFAULT_FACE_DESCRIPTOR_ID = "default";
    private String id;
    private String defaultFaceDescriptorId = "default";
    private boolean enabled = true;
    private boolean visible = true;
    private boolean authorized = true;
    private String securityControllerId = null;
    private Map faceButtonManagers;
    private CommandServices commandServices;
    private CommandFaceDescriptorRegistry faceDescriptorRegistry;
    private Boolean oldEnabledState;
    private Boolean oldVisibleState;

    protected AbstractCommand() {
        this(null);
    }

    protected AbstractCommand(String id) {
        this.setId(id);
        this.addEnabledListener(new ButtonEnablingListener());
        this.addPropertyChangeListener(VISIBLE_PROPERTY_NAME, new ButtonVisibleListener());
    }

    protected AbstractCommand(String id, String encodedLabel) {
        this(id, new CommandFaceDescriptor(encodedLabel));
    }

    protected AbstractCommand(String id, String encodedLabel, Icon icon, String caption) {
        this(id, new CommandFaceDescriptor(encodedLabel, icon, caption));
    }

    protected AbstractCommand(String id, CommandFaceDescriptor faceDescriptor) {
        this(id);
        if (faceDescriptor != null) {
            this.setFaceDescriptor(faceDescriptor);
        }
    }

    protected AbstractCommand(String id, Map faceDescriptors) {
        this(id);
        this.setFaceDescriptors(faceDescriptors);
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        if (!StringUtils.hasText((String)id)) {
            id = null;
        }
        this.id = id;
    }

    public void setBeanName(String name) {
        if (this.getId() == null) {
            this.setId(name);
        }
    }

    public void setFaceDescriptor(CommandFaceDescriptor faceDescriptor) {
        this.setFaceDescriptor(this.getDefaultFaceDescriptorId(), faceDescriptor);
    }

    public void setFaceDescriptor(String faceDescriptorId, CommandFaceDescriptor faceDescriptor) {
        this.getButtonManager(faceDescriptorId).setFaceDescriptor(faceDescriptor);
    }

    public void setFaceDescriptors(Map faceDescriptors) {
        Assert.notNull((Object)faceDescriptors);
        Iterator it = faceDescriptors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String faceDescriptorId = (String)entry.getKey();
            CommandFaceDescriptor faceDescriptor = (CommandFaceDescriptor)entry.getValue();
            this.setFaceDescriptor(faceDescriptorId, faceDescriptor);
        }
    }

    public void setDefaultFaceDescriptorId(String defaultFaceDescriptorId) {
        this.defaultFaceDescriptorId = defaultFaceDescriptorId;
    }

    public void setFaceDescriptorRegistry(CommandFaceDescriptorRegistry faceDescriptorRegistry) {
        this.faceDescriptorRegistry = faceDescriptorRegistry;
    }

    public void setCommandServices(CommandServices services) {
        this.commandServices = services;
    }

    public void setLabel(String encodedLabel) {
        this.getOrCreateFaceDescriptor().setButtonLabelInfo(encodedLabel);
    }

    public void setLabel(CommandButtonLabelInfo label) {
        this.getOrCreateFaceDescriptor().setLabelInfo(label);
    }

    public void setCaption(String shortDescription) {
        this.getOrCreateFaceDescriptor().setCaption(shortDescription);
    }

    public void setIcon(Icon icon) {
        this.getOrCreateFaceDescriptor().setIcon(icon);
    }

    public void setIconInfo(CommandButtonIconInfo iconInfo) {
        this.getOrCreateFaceDescriptor().setIconInfo(iconInfo);
    }

    public void afterPropertiesSet() {
        if (this.getId() == null) {
            this.logger.info((Object)("Command " + this + " has no set id; note: anonymous commands cannot be used in registries."));
        }
        if (this instanceof ActionCommand && !this.isFaceConfigured()) {
            this.logger.warn((Object)("The face descriptor property is not yet set for action command '" + this.getId() + "'; command won't render correctly until this is configured"));
        }
    }

    private CommandFaceDescriptor getOrCreateFaceDescriptor() {
        if (!this.isFaceConfigured()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Lazily instantiating default face descriptor on behalf of caller to prevent npe; command is being configured manually, right?");
            }
            this.setFaceDescriptor(new CommandFaceDescriptor());
        }
        return this.getFaceDescriptor();
    }

    public String getDefaultFaceDescriptorId() {
        if (!StringUtils.hasText((String)this.defaultFaceDescriptorId)) {
            return DEFAULT_FACE_DESCRIPTOR_ID;
        }
        return this.defaultFaceDescriptorId;
    }

    protected CommandFaceDescriptor getFaceDescriptor() {
        return this.getDefaultButtonManager().getFaceDescriptor();
    }

    public boolean isFaceConfigured() {
        return this.getDefaultButtonManager().isFaceConfigured();
    }

    public Icon getIcon() {
        if (this.isFaceConfigured()) {
            return this.getFaceDescriptor().getIcon();
        }
        return null;
    }

    public String getText() {
        if (this.isFaceConfigured()) {
            return this.getFaceDescriptor().getText();
        }
        return CommandButtonLabelInfo.BLANK_BUTTON_LABEL.getText();
    }

    public int getMnemonic() {
        if (this.isFaceConfigured()) {
            return this.getFaceDescriptor().getMnemonic();
        }
        return CommandButtonLabelInfo.BLANK_BUTTON_LABEL.getMnemonic();
    }

    public int getMnemonicIndex() {
        if (this.isFaceConfigured()) {
            return this.getFaceDescriptor().getMnemonicIndex();
        }
        return CommandButtonLabelInfo.BLANK_BUTTON_LABEL.getMnemonicIndex();
    }

    public KeyStroke getAccelerator() {
        if (this.isFaceConfigured()) {
            return this.getFaceDescriptor().getAccelerator();
        }
        return CommandButtonLabelInfo.BLANK_BUTTON_LABEL.getAccelerator();
    }

    public CommandFaceDescriptorRegistry getFaceDescriptorRegistry() {
        return this.faceDescriptorRegistry;
    }

    protected CommandServices getCommandServices() {
        if (this.commandServices == null) {
            this.commandServices = (CommandServices)ApplicationServicesLocator.services().getService(CommandServices.class);
        }
        return this.commandServices;
    }

    public void setSecurityControllerId(String controllerId) {
        this.securityControllerId = controllerId;
    }

    public String getSecurityControllerId() {
        return this.securityControllerId;
    }

    public void setAuthorized(boolean authorized) {
        boolean wasAuthorized = this.isAuthorized();
        if (this.hasChanged(wasAuthorized, authorized)) {
            this.authorized = authorized;
            this.firePropertyChange("authorized", wasAuthorized, authorized);
            this.updatedEnabledState();
        }
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public boolean isEnabled() {
        return this.enabled && this.isAuthorized();
    }

    protected void updatedEnabledState() {
        boolean isEnabled = this.isEnabled();
        if (this.oldEnabledState == null || this.hasChanged(this.oldEnabledState, isEnabled)) {
            this.firePropertyChange(ENABLED_PROPERTY_NAME, this.oldEnabledState == null ? !isEnabled : this.oldEnabledState, isEnabled);
        }
        this.oldEnabledState = isEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.hasChanged(this.enabled, enabled)) {
            this.enabled = enabled;
            this.updatedEnabledState();
        }
    }

    public void addEnabledListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(ENABLED_PROPERTY_NAME, listener);
    }

    public void removeEnabledListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(ENABLED_PROPERTY_NAME, listener);
    }

    protected final Iterator defaultButtonIterator() {
        return this.getDefaultButtonManager().iterator();
    }

    protected final Iterator buttonIterator() {
        if (this.faceButtonManagers == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return new NestedButtonIterator(this.faceButtonManagers.values().iterator());
    }

    public boolean isAnonymous() {
        return this.id == null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            this.updatedVisibleState();
        }
    }

    protected void updatedVisibleState() {
        boolean isVisible = this.isVisible();
        if (this.oldVisibleState == null || this.hasChanged(this.oldVisibleState, isVisible)) {
            this.firePropertyChange(VISIBLE_PROPERTY_NAME, this.oldVisibleState == null ? !isVisible : this.oldVisibleState, isVisible);
        }
        this.oldVisibleState = isVisible;
    }

    public final AbstractButton createButton() {
        return this.createButton(this.getDefaultFaceDescriptorId(), this.getButtonFactory(), this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createButton(String faceDescriptorId) {
        return this.createButton(faceDescriptorId, this.getButtonFactory(), this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createButton(ButtonFactory buttonFactory) {
        return this.createButton(this.getDefaultFaceDescriptorId(), buttonFactory, this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory) {
        return this.createButton(faceDescriptorId, buttonFactory, this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createButton(ButtonFactory buttonFactory, CommandButtonConfigurer buttonConfigurer) {
        return this.createButton(this.getDefaultFaceDescriptorId(), buttonFactory, buttonConfigurer);
    }

    public AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory, CommandButtonConfigurer buttonConfigurer) {
        AbstractButton button = buttonFactory.createButton();
        this.attach(button, faceDescriptorId, buttonConfigurer);
        return button;
    }

    public final JMenuItem createMenuItem() {
        return this.createMenuItem(this.getDefaultFaceDescriptorId(), this.getMenuFactory(), this.getMenuItemButtonConfigurer());
    }

    public final JMenuItem createMenuItem(String faceDescriptorId) {
        return this.createMenuItem(faceDescriptorId, this.getMenuFactory(), this.getMenuItemButtonConfigurer());
    }

    public final JMenuItem createMenuItem(MenuFactory menuFactory) {
        return this.createMenuItem(this.getDefaultFaceDescriptorId(), menuFactory, this.getMenuItemButtonConfigurer());
    }

    public final JMenuItem createMenuItem(String faceDescriptorId, MenuFactory menuFactory) {
        return this.createMenuItem(faceDescriptorId, menuFactory, this.getMenuItemButtonConfigurer());
    }

    public final JMenuItem createMenuItem(MenuFactory menuFactory, CommandButtonConfigurer buttonConfigurer) {
        return this.createMenuItem(this.getDefaultFaceDescriptorId(), menuFactory, buttonConfigurer);
    }

    public JMenuItem createMenuItem(String faceDescriptorId, MenuFactory menuFactory, CommandButtonConfigurer buttonConfigurer) {
        JMenuItem menuItem = menuFactory.createMenuItem();
        this.attach(menuItem, faceDescriptorId, buttonConfigurer);
        return menuItem;
    }

    public void attach(AbstractButton button) {
        this.attach(button, this.getDefaultFaceDescriptorId(), this.getCommandServices().getDefaultButtonConfigurer());
    }

    public void attach(AbstractButton button, CommandButtonConfigurer configurer) {
        this.attach(button, this.getDefaultFaceDescriptorId(), configurer);
    }

    public void attach(AbstractButton button, String faceDescriptorId, CommandButtonConfigurer configurer) {
        this.getButtonManager(faceDescriptorId).attachAndConfigure(button, configurer);
        this.onButtonAttached(button);
    }

    protected void onButtonAttached(AbstractButton button) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Configuring newly attached button for command '" + this.getId() + "' enabled=" + this.isEnabled() + ", visible=" + this.isVisible()));
        }
        button.setEnabled(this.isEnabled());
        button.setVisible(this.isVisible());
    }

    public void detach(AbstractButton button) {
        if (this.getDefaultButtonManager().isAttachedTo(button)) {
            this.getDefaultButtonManager().detach(button);
            this.onButtonDetached();
        }
    }

    public boolean isAttached(AbstractButton b) {
        return this.getDefaultButtonManager().isAttachedTo(b);
    }

    protected void onButtonDetached() {
    }

    private CommandFaceButtonManager getDefaultButtonManager() {
        return this.getButtonManager(this.getDefaultFaceDescriptorId());
    }

    private CommandFaceButtonManager getButtonManager(String faceDescriptorId) {
        if (this.faceButtonManagers == null) {
            this.faceButtonManagers = new CachingMapDecorator(){

                protected Object create(Object key) {
                    return new CommandFaceButtonManager(AbstractCommand.this, (String)key);
                }
            };
        }
        CommandFaceButtonManager m = (CommandFaceButtonManager)this.faceButtonManagers.get(faceDescriptorId);
        return m;
    }

    protected CommandButtonConfigurer getDefaultButtonConfigurer() {
        return this.getCommandServices().getDefaultButtonConfigurer();
    }

    protected CommandButtonConfigurer getToolBarButtonConfigurer() {
        return this.getCommandServices().getToolBarButtonConfigurer();
    }

    protected ButtonFactory getToolBarButtonFactory() {
        return this.getCommandServices().getToolBarButtonFactory();
    }

    protected CommandButtonConfigurer getMenuItemButtonConfigurer() {
        return this.getCommandServices().getMenuItemButtonConfigurer();
    }

    protected ComponentFactory getComponentFactory() {
        return this.getCommandServices().getComponentFactory();
    }

    protected ButtonFactory getButtonFactory() {
        return this.getCommandServices().getButtonFactory();
    }

    protected MenuFactory getMenuFactory() {
        return this.getCommandServices().getMenuFactory();
    }

    public boolean requestFocusIn(Container container) {
        AbstractButton button = this.getButtonIn(container);
        if (button != null) {
            return button.requestFocusInWindow();
        }
        return false;
    }

    public AbstractButton getButtonIn(Container container) {
        Iterator it = this.buttonIterator();
        while (it.hasNext()) {
            AbstractButton button = (AbstractButton)it.next();
            if (!SwingUtilities.isDescendingFrom(button, container)) continue;
            return button;
        }
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append(ENABLED_PROPERTY_NAME, this.enabled).append(VISIBLE_PROPERTY_NAME, this.visible).append("defaultFaceDescriptorId", (Object)this.defaultFaceDescriptorId).toString();
    }

    private static final class NestedButtonIterator
    implements Iterator {
        private final Iterator managerIterator;
        private Iterator currentButtonIterator;
        private AbstractButton nextButton;

        NestedButtonIterator(Iterator it) {
            this.managerIterator = it;
            this.preFetchNextButton();
        }

        public boolean hasNext() {
            return this.nextButton != null;
        }

        public Object next() {
            if (this.nextButton == null) {
                throw new NoSuchElementException();
            }
            AbstractButton lastButton = this.nextButton;
            this.preFetchNextButton();
            return lastButton;
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't use a button-iterator on AbstractCommand to remove buttons.");
        }

        private void preFetchNextButton() {
            while (this.currentButtonIterator == null || !this.currentButtonIterator.hasNext()) {
                if (this.managerIterator.hasNext()) {
                    CommandFaceButtonManager cfbm = (CommandFaceButtonManager)this.managerIterator.next();
                    this.currentButtonIterator = cfbm.iterator();
                    continue;
                }
                this.currentButtonIterator = null;
                this.nextButton = null;
                return;
            }
            this.nextButton = this.currentButtonIterator.hasNext() ? (AbstractButton)this.currentButtonIterator.next() : null;
        }
    }

    private class ButtonVisibleListener
    implements PropertyChangeListener {
        private ButtonVisibleListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean enabled = evt.getNewValue() == Boolean.TRUE;
            Iterator it = AbstractCommand.this.buttonIterator();
            while (it.hasNext()) {
                AbstractButton button = (AbstractButton)it.next();
                button.setVisible(enabled);
            }
        }
    }

    private class ButtonEnablingListener
    implements PropertyChangeListener {
        private ButtonEnablingListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean enabled = evt.getNewValue() == Boolean.TRUE;
            Iterator it = AbstractCommand.this.buttonIterator();
            while (it.hasNext()) {
                AbstractButton button = (AbstractButton)it.next();
                button.setEnabled(enabled);
            }
        }
    }
}

