/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.awt.Component;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.PropertyNotSetException;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandRegistry;
import org.springframework.richclient.command.ExclusiveCommandGroup;
import org.springframework.richclient.command.InvalidGroupMemberEncodingException;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.core.SecurityControllable;
import org.springframework.richclient.util.Assert;
import org.springframework.util.StringUtils;

public class CommandGroupFactoryBean
implements BeanNameAware,
FactoryBean,
SecurityControllable,
InitializingBean {
    public static final String GLUE_MEMBER_CODE = "glue";
    public static final String SEPARATOR_MEMBER_CODE = "separator";
    public static final String COMMAND_MEMBER_PREFIX = "command:";
    public static final String GROUP_MEMBER_PREFIX = "group:";
    protected Log logger = LogFactory.getLog(this.getClass());
    private String groupId;
    private CommandRegistry commandRegistry;
    private CommandConfigurer commandConfigurer;
    private Object[] members;
    private boolean exclusive;
    private boolean allowsEmptySelection;
    private CommandGroup commandGroup;
    private String securityControllerId;

    public CommandGroupFactoryBean() {
    }

    public CommandGroupFactoryBean(String groupId, Object[] members) {
        this(groupId, null, null, members);
    }

    public CommandGroupFactoryBean(String groupId, CommandRegistry commandRegistry, Object[] members) {
        this(groupId, commandRegistry, null, members);
    }

    public CommandGroupFactoryBean(String groupId, CommandRegistry commandRegistry, CommandConfigurer commandConfigurer, Object[] members) {
        Assert.required((Object)members, (String)"members");
        this.groupId = groupId;
        this.commandRegistry = commandRegistry;
        this.members = members;
        this.commandConfigurer = commandConfigurer;
    }

    public void afterPropertiesSet() {
        PropertyNotSetException.throwIfNull((Object)this.members, (String)"members", this.getClass());
    }

    public void setCommandRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    protected CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public void setCommandConfigurer(CommandConfigurer configurer) {
        this.commandConfigurer = configurer;
    }

    public final void setMembers(Object[] members) {
        Assert.required((Object)members, (String)"members");
        this.members = members;
    }

    protected Object[] getMembers() {
        return this.members;
    }

    public void setBeanName(String beanName) {
        this.groupId = beanName;
    }

    protected String getBeanName() {
        return this.groupId;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setAllowsEmptySelection(boolean allowsEmptySelection) {
        this.allowsEmptySelection = allowsEmptySelection;
    }

    protected boolean isAllowsEmptySelection() {
        return this.allowsEmptySelection;
    }

    public Object getObject() throws Exception {
        return this.getCommandGroup();
    }

    public CommandGroup getCommandGroup() {
        if (this.commandGroup == null) {
            this.commandGroup = this.createCommandGroup();
        }
        return this.commandGroup;
    }

    protected CommandGroup createCommandGroup() {
        CommandGroup group;
        if (this.isExclusive()) {
            ExclusiveCommandGroup g = new ExclusiveCommandGroup(this.getBeanName(), this.getCommandRegistry());
            g.setAllowsEmptySelection(this.isAllowsEmptySelection());
            group = g;
        } else {
            group = new CommandGroup(this.getBeanName(), this.getCommandRegistry());
        }
        group.setSecurityControllerId(this.getSecurityControllerId());
        this.initCommandGroupMembers(group);
        return group;
    }

    protected void initCommandGroupMembers(CommandGroup group) {
        for (int i = 0; i < this.members.length; ++i) {
            String commandId;
            Object o = this.members[i];
            if (o instanceof AbstractCommand) {
                group.addInternal((AbstractCommand)o);
                this.configureIfNecessary((AbstractCommand)o);
                continue;
            }
            if (o instanceof Component) {
                group.addComponentInternal((Component)o);
                continue;
            }
            if (!(o instanceof String)) continue;
            String str = (String)o;
            if (str.equalsIgnoreCase(SEPARATOR_MEMBER_CODE)) {
                group.addSeparatorInternal();
                continue;
            }
            if (str.equalsIgnoreCase(GLUE_MEMBER_CODE)) {
                group.addGlueInternal();
                continue;
            }
            if (str.startsWith(COMMAND_MEMBER_PREFIX)) {
                commandId = str.substring(COMMAND_MEMBER_PREFIX.length());
                if (!StringUtils.hasText((String)commandId)) {
                    throw new InvalidGroupMemberEncodingException("The group member encoding does not specify a command id", str);
                }
                this.addCommandMember(str.substring(COMMAND_MEMBER_PREFIX.length()), group);
                continue;
            }
            if (str.startsWith(GROUP_MEMBER_PREFIX)) {
                commandId = str.substring(GROUP_MEMBER_PREFIX.length());
                if (!StringUtils.hasText((String)commandId)) {
                    throw new InvalidGroupMemberEncodingException("The group member encoding does not specify a command id", str);
                }
                this.addCommandMember(commandId, group);
                continue;
            }
            this.addCommandMember(str, group);
        }
    }

    private void addCommandMember(String commandId, CommandGroup group) {
        Assert.required((Object)commandId, (String)"commandId");
        Assert.required((Object)group, (String)"group");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("adding command group member with id [" + commandId + "] to group [" + group.getId() + "]"));
        }
        AbstractCommand command = null;
        if (this.commandRegistry != null && (command = (AbstractCommand)this.commandRegistry.getCommand(commandId)) != null) {
            group.addInternal(command);
        }
        if (command == null) {
            group.addLazyInternal(commandId);
        }
    }

    protected void configureIfNecessary(AbstractCommand command) {
        Assert.required((Object)command, (String)"command");
        if (this.commandConfigurer != null && !command.isFaceConfigured()) {
            this.commandConfigurer.configure(command);
        }
    }

    public Class getObjectType() {
        return CommandGroup.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSecurityControllerId(String controllerId) {
        this.securityControllerId = controllerId;
    }

    public String getSecurityControllerId() {
        return this.securityControllerId;
    }

    public void setAuthorized(boolean authorized) {
    }

    public boolean isAuthorized() {
        return false;
    }
}

