/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.AbstractButton;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.util.Assert;

public class ComponentGroupMember
extends GroupMember {
    private Component component;

    public ComponentGroupMember(Component component) {
        Assert.required((Object)component, (String)"component");
        this.component = component;
    }

    public void setEnabled(boolean enabled) {
        this.component.setEnabled(enabled);
    }

    public boolean managesCommand(String commandId) {
        if (null != commandId) {
            return this.managesCommand(this.component, commandId);
        }
        return false;
    }

    private boolean managesCommand(Component component, String commandId) {
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            if (null != button.getActionCommand() && button.getActionCommand().equals(commandId)) {
                return true;
            }
        } else if (component instanceof Container) {
            Component[] subComponents = ((Container)component).getComponents();
            for (int i = 0; i < subComponents.length; ++i) {
                if (!this.managesCommand(subComponents[i], commandId)) continue;
                return true;
            }
        }
        return false;
    }

    protected void fill(GroupContainerPopulator containerPopulator, Object controlFactory, CommandButtonConfigurer buttonConfigurer, List previousButtons) {
        Assert.required((Object)containerPopulator, (String)"containerPopulator");
        containerPopulator.add(this.component);
    }
}

