/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import org.springframework.richclient.command.CommandException;

public class InvalidGroupMemberException
extends CommandException {
    private static final long serialVersionUID = 7891614557214887191L;
    private final Class invalidMemberClass;
    private final Class commandGroupClass;

    private static String createDefaultMessage(Class invalidMemberClass, Class commandGroupClass) {
        return "An object of type [" + invalidMemberClass + "] is not a valid member for a group of type [" + commandGroupClass + "]";
    }

    public InvalidGroupMemberException(Class invalidMemberClass, Class commandGroupClass) {
        super(InvalidGroupMemberException.createDefaultMessage(invalidMemberClass, commandGroupClass));
        this.invalidMemberClass = invalidMemberClass;
        this.commandGroupClass = commandGroupClass;
    }

    public InvalidGroupMemberException(String message, Class invalidMemberClass, Class commandGroupClass) {
        this(message, invalidMemberClass, commandGroupClass, null);
    }

    public InvalidGroupMemberException(String message, Class invalidMemberClass, Class commandGroupClass, Throwable cause) {
        super(message, cause);
        this.invalidMemberClass = invalidMemberClass;
        this.commandGroupClass = commandGroupClass;
    }

    public Class getCommandGroupClass() {
        return this.commandGroupClass;
    }

    public Class getInvalidMemberClass() {
        return this.invalidMemberClass;
    }
}

