/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.config;

import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.springframework.binding.value.support.AbstractPropertyChangePublisher;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandButtonIconInfo;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.config.CommandIconConfigurable;
import org.springframework.richclient.command.config.CommandLabelConfigurable;
import org.springframework.richclient.core.DescribedElement;
import org.springframework.richclient.core.DescriptionConfigurable;
import org.springframework.richclient.core.VisualizedElement;
import org.springframework.richclient.util.Assert;

public class CommandFaceDescriptor
extends AbstractPropertyChangePublisher
implements DescribedElement,
VisualizedElement,
CommandLabelConfigurable,
DescriptionConfigurable,
CommandIconConfigurable {
    public static final String LABEL_INFO_PROPERTY = "labelInfo";
    public static final String ICON_PROPERTY = "icon";
    public static final String LARGE_ICON_PROPERTY = "largeIcon";
    public static final String ICON_INFO_PROPERTY = "iconInfo";
    public static final String LARGE_ICON_INFO_PROPERTY = "largeIconInfo";
    private String caption;
    private String description;
    private CommandButtonLabelInfo labelInfo;
    private CommandButtonIconInfo iconInfo = CommandButtonIconInfo.BLANK_ICON_INFO;
    private CommandButtonIconInfo largeIconInfo = CommandButtonIconInfo.BLANK_ICON_INFO;

    public CommandFaceDescriptor(String encodedLabel) {
        this(encodedLabel, null, null);
    }

    public CommandFaceDescriptor(String encodedLabel, Icon icon, String caption) {
        this.labelInfo = CommandButtonLabelInfo.valueOf(encodedLabel);
        if (icon != null) {
            this.iconInfo = new CommandButtonIconInfo(icon);
        }
        this.caption = caption;
    }

    public CommandFaceDescriptor() {
        this(CommandButtonLabelInfo.BLANK_BUTTON_LABEL);
    }

    public CommandFaceDescriptor(CommandButtonLabelInfo labelInfo) {
        Assert.notNull((Object)labelInfo, (String)"The labelInfo property is required");
        this.labelInfo = labelInfo;
    }

    public boolean isBlank() {
        return this.labelInfo == CommandButtonLabelInfo.BLANK_BUTTON_LABEL;
    }

    public String getText() {
        return this.labelInfo.getText();
    }

    public String getDisplayName() {
        return this.getText();
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMnemonic() {
        return this.labelInfo.getMnemonic();
    }

    public int getMnemonicIndex() {
        return this.labelInfo.getMnemonicIndex();
    }

    public Image getImage() {
        if (this.iconInfo == null) {
            return null;
        }
        return this.iconInfo.getImage();
    }

    public Icon getIcon() {
        if (this.iconInfo == null) {
            return null;
        }
        return this.iconInfo.getIcon();
    }

    public Icon getLargeIcon() {
        if (this.largeIconInfo == null) {
            return null;
        }
        return this.largeIconInfo.getIcon();
    }

    public KeyStroke getAccelerator() {
        return this.labelInfo.getAccelerator();
    }

    protected CommandButtonLabelInfo getLabelInfo() {
        return this.labelInfo;
    }

    protected CommandButtonIconInfo getIconInfo() {
        return this.iconInfo;
    }

    protected CommandButtonIconInfo getLargeIconInfo() {
        return this.largeIconInfo;
    }

    public void setCaption(String shortDescription) {
        String old = this.caption;
        this.caption = shortDescription;
        this.firePropertyChange("caption", old, this.caption);
    }

    public void setDescription(String longDescription) {
        String old = this.description;
        this.description = longDescription;
        this.firePropertyChange("description", old, this.description);
    }

    public void setButtonLabelInfo(String encodedLabelInfo) {
        CommandButtonLabelInfo newLabelInfo = CommandButtonLabelInfo.valueOf(encodedLabelInfo);
        this.setLabelInfo(newLabelInfo);
    }

    public void setLabelInfo(CommandButtonLabelInfo labelInfo) {
        if (labelInfo == null) {
            labelInfo = CommandButtonLabelInfo.BLANK_BUTTON_LABEL;
        }
        CommandButtonLabelInfo old = this.labelInfo;
        this.labelInfo = labelInfo;
        this.firePropertyChange(LABEL_INFO_PROPERTY, old, this.labelInfo);
    }

    public void setIconInfo(CommandButtonIconInfo iconInfo) {
        if (iconInfo == null) {
            iconInfo = CommandButtonIconInfo.BLANK_ICON_INFO;
        }
        CommandButtonIconInfo old = this.iconInfo;
        this.iconInfo = iconInfo;
        this.firePropertyChange(ICON_INFO_PROPERTY, old, this.iconInfo);
    }

    public void setLargeIconInfo(CommandButtonIconInfo largeIconInfo) {
        if (largeIconInfo == null) {
            largeIconInfo = CommandButtonIconInfo.BLANK_ICON_INFO;
        }
        CommandButtonIconInfo old = this.largeIconInfo;
        this.largeIconInfo = largeIconInfo;
        this.firePropertyChange(LARGE_ICON_INFO_PROPERTY, old, this.largeIconInfo);
    }

    public void setIcon(Icon icon) {
        Icon old = null;
        if (this.iconInfo == CommandButtonIconInfo.BLANK_ICON_INFO) {
            if (icon != null) {
                this.setIconInfo(new CommandButtonIconInfo(icon));
            }
        } else {
            old = this.iconInfo.getIcon();
            this.iconInfo.setIcon(icon);
        }
        this.firePropertyChange(ICON_PROPERTY, old, icon);
    }

    public void setLargeIcon(Icon icon) {
        Icon old = null;
        if (this.largeIconInfo == CommandButtonIconInfo.BLANK_ICON_INFO) {
            if (icon != null) {
                this.setLargeIconInfo(new CommandButtonIconInfo(icon));
            }
        } else {
            old = this.largeIconInfo.getIcon();
            this.largeIconInfo.setIcon(icon);
        }
        this.firePropertyChange(LARGE_ICON_PROPERTY, old, icon);
    }

    public void configureLabel(AbstractButton button) {
        Assert.required((Object)button, (String)"button");
        this.labelInfo.configure(button);
    }

    public void configureIcon(AbstractButton button) {
        Assert.required((Object)button, (String)"button");
        this.configureIconInfo(button, false);
    }

    public void configureIconInfo(AbstractButton button, boolean useLargeIcons) {
        Assert.required((Object)button, (String)"button");
        if (useLargeIcons) {
            this.largeIconInfo.configure(button);
        } else {
            this.iconInfo.configure(button);
        }
    }

    public void configure(AbstractButton button, AbstractCommand command, CommandButtonConfigurer configurer) {
        Assert.required((Object)button, (String)"button");
        Assert.required((Object)configurer, (String)"configurer");
        configurer.configure(button, command, this);
    }

    public void configure(Action action) {
        Assert.notNull((Object)action, (String)"The swing action to configure is required");
        action.putValue("Name", this.getText());
        action.putValue("MnemonicKey", new Integer(this.getMnemonic()));
        action.putValue("SmallIcon", this.getIcon());
        action.putValue("LargeIcon", this.getLargeIcon());
        action.putValue("AcceleratorKey", this.getAccelerator());
        action.putValue("ShortDescription", this.caption);
        action.putValue("LongDescription", this.description);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("caption", (Object)this.caption).append("description", (Object)this.description).append("buttonLabelInfo", (Object)this.labelInfo).append("buttonIconInfo", (Object)this.iconInfo).toString();
    }
}

