/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.AbstractButton;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CommandFaceButtonManager
implements PropertyChangeListener {
    private Set buttons = new HashSet(6);
    private AbstractCommand command;
    private String faceDescriptorId;
    private CommandFaceDescriptor faceDescriptor;

    public CommandFaceButtonManager(AbstractCommand command, String faceDescriptorKey) {
        Assert.notNull((Object)command, (String)"The command to manage buttons for cannot be null");
        Assert.hasText((String)faceDescriptorKey, (String)"The face descriptor key is required");
        this.command = command;
        this.faceDescriptorId = faceDescriptorKey;
    }

    public CommandFaceButtonManager(AbstractCommand command, CommandFaceDescriptor faceDescriptor) {
        this.command = command;
        this.setFaceDescriptor(faceDescriptor);
    }

    public void setFaceDescriptor(CommandFaceDescriptor faceDescriptor) {
        Assert.notNull((Object)faceDescriptor, (String)"The face descriptor for managing command button appearance is required");
        if (!ObjectUtils.nullSafeEquals((Object)this.faceDescriptor, (Object)faceDescriptor)) {
            if (this.faceDescriptor != null) {
                this.faceDescriptor.removePropertyChangeListener(this);
            }
            this.faceDescriptor = faceDescriptor;
            this.faceDescriptor.addPropertyChangeListener(this);
            this.propertyChange(null);
        }
    }

    public CommandFaceDescriptor getFaceDescriptor() {
        return this.faceDescriptor;
    }

    public boolean isFaceConfigured() {
        return this.faceDescriptor != null;
    }

    public void attachAndConfigure(AbstractButton button, CommandButtonConfigurer strategy) {
        ManagedButton managedButton;
        Assert.notNull((Object)button, (String)"The button to attach and configure is required");
        Assert.notNull((Object)strategy, (String)"The button configuration strategy is required");
        if (!this.isAttachedTo(button) && this.buttons.add(managedButton = new ManagedButton(button, strategy))) {
            this.configure(button, strategy);
        }
    }

    private void cleanUp() {
        Iterator i = this.buttons.iterator();
        while (i.hasNext()) {
            ManagedButton button = (ManagedButton)i.next();
            if (button.getButton() != null) continue;
            i.remove();
        }
    }

    protected void configure(AbstractButton button, CommandButtonConfigurer strategy) {
        if (this.faceDescriptor == null) {
            if (this.command.getFaceDescriptorRegistry() != null) {
                this.setFaceDescriptor(this.command.getFaceDescriptorRegistry().getFaceDescriptor(this.command, this.faceDescriptorId));
            } else {
                this.setFaceDescriptor(new CommandFaceDescriptor());
            }
        }
        this.getFaceDescriptor().configure(button, this.command, strategy);
    }

    public void detach(AbstractButton button) {
        this.buttons.remove(this.findManagedButton(button));
    }

    public void detachAll() {
        this.buttons.clear();
    }

    public boolean isAttachedTo(AbstractButton button) {
        return this.findManagedButton(button) != null;
    }

    protected ManagedButton findManagedButton(AbstractButton button) {
        Assert.notNull((Object)button, (String)"The button is required");
        this.cleanUp();
        Iterator i = this.buttons.iterator();
        while (i.hasNext()) {
            ManagedButton managedButton = (ManagedButton)i.next();
            if (!button.equals(managedButton.getButton())) continue;
            return managedButton;
        }
        return null;
    }

    public Iterator iterator() {
        this.cleanUp();
        return new ButtonIterator(this.buttons.iterator());
    }

    public void propertyChange(PropertyChangeEvent e) {
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            ManagedButton mb = (ManagedButton)it.next();
            Assert.notNull((Object)mb, (String)"Managed button reference cannot be null");
            if (mb.getButton() == null) {
                it.remove();
                continue;
            }
            this.configure(mb.getButton(), mb.buttonConfigurer);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("commandId", (Object)this.command.getId()).append("faceDescriptor", (Object)this.faceDescriptor).append("attachedButtonCount", this.buttons.size()).toString();
    }

    private static class ButtonIterator
    implements Iterator {
        private Iterator it;
        private AbstractButton nextButton;

        public ButtonIterator(Iterator it) {
            this.it = it;
            this.fetchNextButton();
        }

        public boolean hasNext() {
            return this.nextButton != null;
        }

        public Object next() {
            if (this.nextButton == null) {
                throw new NoSuchElementException();
            }
            AbstractButton lastButton = this.nextButton;
            this.fetchNextButton();
            return lastButton;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchNextButton() {
            while (this.it.hasNext()) {
                ManagedButton managedButton = (ManagedButton)this.it.next();
                this.nextButton = managedButton.getButton();
                if (this.nextButton == null) continue;
                return;
            }
            this.nextButton = null;
        }
    }

    private static class ManagedButton {
        private WeakReference buttonHolder;
        private CommandButtonConfigurer buttonConfigurer;
        private int hashCode;

        public ManagedButton(AbstractButton button, CommandButtonConfigurer buttonConfigurer) {
            this.buttonHolder = new WeakReference<AbstractButton>(button);
            this.buttonConfigurer = buttonConfigurer;
            this.hashCode = button.hashCode();
        }

        public AbstractButton getButton() {
            return (AbstractButton)this.buttonHolder.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return ObjectUtils.nullSafeEquals((Object)this.getButton(), (Object)((ManagedButton)o).getButton());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

