/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ToggleButtonPopupListener
implements PopupMenuListener,
ItemListener,
MouseListener {
    private AbstractButton button;
    private JPopupMenu menu;
    private boolean buttonWasPressed;

    public static void bind(AbstractButton button, JPopupMenu menu) {
        new ToggleButtonPopupListener(button, menu);
    }

    private ToggleButtonPopupListener(AbstractButton button, JPopupMenu menu) {
        this.button = button;
        this.menu = menu;
        button.addItemListener(this);
        menu.addPopupMenuListener(this);
        button.addMouseListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.button.isSelected()) {
            this.menu.show(this.button, 0, this.button.getHeight());
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (!this.buttonWasPressed) {
            this.button.setSelected(false);
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.buttonWasPressed = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.buttonWasPressed = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

