/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.springframework.util.Assert;

public class GradientPanel
extends JPanel {
    private Color upperLeftColor;
    private Color lowerRightColor;

    public GradientPanel(Color lowerRightColor, Color upperLeftColor) {
        this.lowerRightColor = lowerRightColor;
        this.upperLeftColor = upperLeftColor;
    }

    public GradientPanel(Color lowerRightColor) {
        this(lowerRightColor, Color.white);
    }

    public GradientPanel() {
        this((Color)null);
    }

    private void paintGradientComponent(int w, int h, Graphics2D g2) {
        if (this.lowerRightColor == null) {
            this.lowerRightColor = this.getBackground();
        }
        Assert.notNull((Object)this.upperLeftColor, (String)"The OuterColor cannot be null");
        Rectangle2D.Float rect1 = new Rectangle2D.Float(0.0f, 0.0f, w, h);
        GradientPaint gp = new GradientPaint((float)w * 0.8f, (float)h * 0.3f, this.upperLeftColor, (float)w * 0.9f, (float)h * 0.7f, this.lowerRightColor);
        g2.setPaint(gp);
        g2.fill(rect1);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        g2.setBackground(this.lowerRightColor);
        g2.clearRect(0, 0, d.width, d.height);
        this.paintGradientComponent(d.width, d.height, g2);
    }

    public Color getLowerRightColor() {
        return this.lowerRightColor;
    }

    public void setLowerRightColor(Color lowerRightColor) {
        this.lowerRightColor = lowerRightColor;
    }

    public Color getUpperLeftColor() {
        return this.upperLeftColor;
    }

    public void setUpperLeftColor(Color upperLeftColor) {
        this.upperLeftColor = upperLeftColor;
    }
}

