/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.control;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.Format;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatter;

public class PatchedJFormattedTextField
extends JFormattedTextField {
    private static final String TOGGLE_OVERWRITE_MODE_ACTION = "toggleOverwriteModeAction";

    public PatchedJFormattedTextField() {
        this.customInit();
    }

    public PatchedJFormattedTextField(Object value) {
        super(value);
        this.customInit();
    }

    public PatchedJFormattedTextField(Format format) {
        super(format);
        this.customInit();
    }

    public PatchedJFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.customInit();
    }

    public PatchedJFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.customInit();
    }

    public PatchedJFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
        this.customInit();
    }

    private void customInit() {
        this.setFocusLostBehavior(0);
        if (this.getFormatter() instanceof DefaultFormatter) {
            final DefaultFormatter d = (DefaultFormatter)this.getFormatter();
            AbstractAction toggleOverwrite = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    d.setOverwriteMode(!d.getOverwriteMode());
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(155, 0), TOGGLE_OVERWRITE_MODE_ACTION);
            this.getActionMap().put(TOGGLE_OVERWRITE_MODE_ACTION, toggleOverwrite);
        }
    }

    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks == KeyStroke.getKeyStroke(10, 0) || ks == KeyStroke.getKeyStroke(27, 0)) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }
}

