/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.springframework.binding.value.ValueModel;
import org.springframework.core.closure.Closure;
import org.springframework.core.closure.support.Algorithms;
import org.springframework.core.closure.support.Block;
import org.springframework.richclient.core.Guarded;

public class GuardedGroup
implements Guarded {
    private Boolean groupEnabledState;
    private Set guardedGroup;

    private GuardedGroup() {
    }

    public GuardedGroup(Guarded[] guarded) {
        this.guardedGroup = new HashSet<Guarded>(Arrays.asList(guarded));
    }

    public void addGuarded(Guarded guarded) {
        this.guardedGroup.add(guarded);
    }

    public void addGuardedHolder(ValueModel guardedHolder) {
        this.guardedGroup.add(new GuardedValueModel(this, guardedHolder));
    }

    public boolean isEnabled() {
        if (this.groupEnabledState == null) {
            return false;
        }
        return this.groupEnabledState;
    }

    public void setEnabled(final boolean enabled) {
        if (this.groupEnabledState != null && this.groupEnabledState == enabled) {
            return;
        }
        Algorithms.instance().forEach((Collection)this.guardedGroup, (Closure)new Block(){

            protected void handle(Object guarded) {
                ((Guarded)guarded).setEnabled(enabled);
            }
        });
        this.groupEnabledState = enabled;
    }

    public static final Guarded createGuardedAdapter(final JComponent component) {
        if (component instanceof JTextComponent) {
            final JTextComponent textComp = (JTextComponent)component;
            return new Guarded(){

                public boolean isEnabled() {
                    return textComp.isEditable();
                }

                public void setEnabled(boolean enabled) {
                    textComp.setEditable(enabled);
                }
            };
        }
        return new Guarded(){

            public boolean isEnabled() {
                return component.isEnabled();
            }

            public void setEnabled(boolean enabled) {
                component.setEnabled(enabled);
            }
        };
    }

    private static final Guarded createGuardedAdapter(Object component) {
        if (component.getClass().isArray()) {
            return GuardedGroup.doCreateGuardedGroup((Object[])component);
        }
        return GuardedGroup.createGuardedAdapter((JComponent)component);
    }

    public static final GuardedGroup createGuardedGroup(Object[] components) {
        return GuardedGroup.doCreateGuardedGroup(components);
    }

    public static final GuardedGroup createGuardedGroup(JComponent[] components) {
        return GuardedGroup.doCreateGuardedGroup(components);
    }

    public static final GuardedGroup createGuardedGroup(JComponent[][] componentArrays) {
        return GuardedGroup.doCreateGuardedGroup((Object[])componentArrays);
    }

    private static GuardedGroup doCreateGuardedGroup(Object[] components) {
        HashSet<Guarded> guardedSet = new HashSet<Guarded>(components.length);
        for (int i = 0; i < components.length; ++i) {
            guardedSet.add(GuardedGroup.createGuardedAdapter(components[i]));
        }
        GuardedGroup g = new GuardedGroup();
        g.guardedGroup = guardedSet;
        return g;
    }

    private static class GuardedValueModel
    implements Guarded,
    PropertyChangeListener {
        private GuardedGroup guardedGroup;
        private ValueModel guardedHolder;

        public GuardedValueModel(GuardedGroup guardedGroup, ValueModel valueModel) {
            this.guardedGroup = guardedGroup;
            this.guardedHolder = valueModel;
            this.guardedHolder.addValueChangeListener((PropertyChangeListener)this);
        }

        public boolean isEnabled() {
            Guarded g = (Guarded)this.guardedHolder.getValue();
            if (g != null) {
                return g.isEnabled();
            }
            return false;
        }

        public void setEnabled(boolean enabled) {
            Guarded g = (Guarded)this.guardedHolder.getValue();
            if (g != null) {
                g.setEnabled(enabled);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Boolean groupEnabled = this.guardedGroup.groupEnabledState;
            if (groupEnabled != null) {
                this.setEnabled(groupEnabled);
            }
        }
    }
}

