/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.springframework.richclient.dialog.AbstractDialogPage;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.dialog.FormBackedDialogPage;
import org.springframework.richclient.form.Form;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.util.LabelUtils;
import org.springframework.util.Assert;

public abstract class CompositeDialogPage
extends AbstractDialogPage {
    private final ChildChangeHandler childChangeHandler = new ChildChangeHandler();
    private List pages = new ArrayList();
    private int largestPageWidth;
    private int largestPageHeight;
    private boolean autoConfigureChildPages = true;
    private DialogPage activePage;

    public CompositeDialogPage(String pageId) {
        super(pageId, true);
    }

    public CompositeDialogPage(String pageId, boolean autoConfigure) {
        super(pageId, autoConfigure);
    }

    public void setAutoConfigureChildPages(boolean autoConfigure) {
        this.autoConfigureChildPages = autoConfigure;
    }

    public void addPage(DialogPage page) {
        this.pages.add(page);
        if (this.autoConfigureChildPages) {
            String id = this.getId() + "." + page.getId();
            this.getObjectConfigurer().configure(page, id);
        }
    }

    public DialogPage addForm(Form form) {
        DialogPage page = this.createDialogPage(form);
        this.addPage(page);
        return page;
    }

    public void addPages(DialogPage[] pages) {
        for (int i = 0; i < pages.length; ++i) {
            this.addPage(pages[i]);
        }
    }

    protected void addPages() {
    }

    protected List getPages() {
        return this.pages;
    }

    public void setActivePage(DialogPage activePage) {
        DialogPage oldPage = this.activePage;
        Assert.isTrue((activePage == null || this.pages.contains(activePage) ? 1 : 0) != 0);
        if (oldPage == activePage) {
            return;
        }
        this.activePage = activePage;
        this.updateMessage();
        if (oldPage != null) {
            this.updatePageLabels(oldPage);
        }
        if (activePage != null) {
            this.updatePageLabels(activePage);
        }
    }

    public DialogPage getActivePage() {
        return this.activePage;
    }

    protected DialogPage createDialogPage(Form form) {
        return new FormBackedDialogPage(form, !this.autoConfigureChildPages);
    }

    protected void createPageControls() {
        this.addPages();
        Assert.notEmpty((Collection)this.getPages(), (String)"Pages must have been added first");
        Iterator i = this.pages.iterator();
        while (i.hasNext()) {
            DialogPage page = (DialogPage)i.next();
            this.prepareDialogPage(page);
        }
    }

    protected void prepareDialogPage(DialogPage page) {
        page.addPropertyChangeListener(this.childChangeHandler);
        JComponent c = page.getControl();
        GuiStandardUtils.attachDialogBorder(c);
        Dimension size = c.getPreferredSize();
        if (size.width > this.largestPageWidth) {
            this.largestPageWidth = size.width;
        }
        if (size.height > this.largestPageHeight) {
            this.largestPageHeight = size.height;
        }
    }

    public Dimension getLargestPageSize() {
        return new Dimension(this.largestPageWidth + 5, this.largestPageHeight + 5);
    }

    protected void updatePageComplete(DialogPage page) {
        boolean pageComplete = true;
        Iterator i = this.pages.iterator();
        while (i.hasNext()) {
            if (((DialogPage)i.next()).isPageComplete()) continue;
            pageComplete = false;
            break;
        }
        this.setPageComplete(pageComplete);
    }

    protected void updatePageEnabled(DialogPage page) {
    }

    protected void updatePageLabels(DialogPage page) {
    }

    protected void updateMessage() {
        if (this.activePage != null) {
            this.setDescription(this.activePage.getDescription());
            this.setMessage(this.activePage.getMessage());
        } else {
            this.setDescription(null);
            this.setMessage(null);
        }
    }

    protected void onPageSelected(DialogPage page, boolean selected) {
    }

    protected void updatePageVisibility(DialogPage page) {
    }

    protected final String getDecoratedPageTitle(DialogPage page) {
        return this.decoratePageTitle(page, page.getTitle());
    }

    protected String decoratePageTitle(DialogPage page, String title) {
        return LabelUtils.htmlBlock("<center>" + title + "<sup><font size=-3 color=red>" + (page.isPageComplete() ? "" : "*"));
    }

    protected class ChildChangeHandler
    implements PropertyChangeListener {
        protected ChildChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            DialogPage page;
            if ("pageComplete".equals(e.getPropertyName())) {
                CompositeDialogPage.this.updatePageComplete((DialogPage)e.getSource());
            } else if ("message".equals(e.getPropertyName())) {
                if (CompositeDialogPage.this.getActivePage() == e.getSource()) {
                    CompositeDialogPage.this.updateMessage();
                }
            } else {
                CompositeDialogPage.this.updatePageLabels((DialogPage)e.getSource());
            }
            if ("visible".equals(e.getPropertyName())) {
                page = (DialogPage)e.getSource();
                CompositeDialogPage.this.updatePageVisibility(page);
            }
            if ("enabled".equals(e.getPropertyName())) {
                page = (DialogPage)e.getSource();
                CompositeDialogPage.this.updatePageEnabled(page);
            }
        }
    }
}

