/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.DefaultMessageAreaPane;
import org.springframework.util.Assert;

public abstract class ConfirmationDialog
extends ApplicationDialog {
    private static final String YES_FACE_DESCRIPTOR_ID = "yesCommand";
    private static final String NO_FACE_DESCRIPTOR_ID = "noCommand";
    private static final String CONFIRMATION_DIALOG_ICON = "confirmationDialog.icon";
    private DefaultMessageAreaPane messageAreaPane;
    private String confirmationMessage;

    public ConfirmationDialog() {
        this("Confirmation Required", null, "Are you sure you wish to perform this action?");
    }

    public ConfirmationDialog(String title, String message) {
        this(title, null, message);
    }

    public ConfirmationDialog(String title, Window parent, String message) {
        super(title, parent);
        this.setConfirmationMessage(message);
    }

    public void setConfirmationMessage(String message) {
        Assert.hasText((String)message, (String)"The confirmation message is required");
        this.confirmationMessage = message;
        if (this.messageAreaPane != null) {
            this.messageAreaPane.setMessage(new DefaultMessage(message));
        }
    }

    protected String getFinishCommandId() {
        return YES_FACE_DESCRIPTOR_ID;
    }

    protected String getCancelCommandId() {
        return NO_FACE_DESCRIPTOR_ID;
    }

    protected void registerDefaultCommand() {
        this.registerCancelCommandAsDefault();
    }

    protected void onInitialized() {
        this.setupKeyBindings();
    }

    private void setupKeyBindings() {
        this.addActionKeyBinding(KeyStroke.getKeyStroke(this.getYesKey(), 0), this.getFinishCommand().getId());
        this.addActionKeyBinding(KeyStroke.getKeyStroke(this.getNoKey(), 0), this.getCancelCommand().getId());
    }

    protected int getYesKey() {
        return this.getFinishCommand().getMnemonic();
    }

    protected int getNoKey() {
        return this.getCancelCommand().getMnemonic();
    }

    protected JComponent createDialogContentPane() {
        this.messageAreaPane = new DefaultMessageAreaPane();
        Icon icon = this.getIconSource().getIcon(CONFIRMATION_DIALOG_ICON);
        if (icon == null) {
            icon = UIManager.getIcon("OptionPane.questionIcon");
        }
        this.messageAreaPane.setDefaultIcon(icon);
        this.messageAreaPane.setMessage(new DefaultMessage(this.confirmationMessage));
        return this.messageAreaPane.getControl();
    }

    protected void disposeDialogContentPane() {
        this.messageAreaPane = null;
    }

    protected final boolean onFinish() {
        this.onConfirm();
        return true;
    }

    protected abstract void onConfirm();
}

