/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.springframework.richclient.core.LabeledObjectSupport;
import org.springframework.richclient.dialog.CompositeDialogPage;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.dialog.control.ExtTabbedPane;
import org.springframework.richclient.dialog.control.Tab;
import org.springframework.richclient.dialog.control.VetoableSingleSelectionModel;

public class TabbedDialogPage
extends CompositeDialogPage {
    private ExtTabbedPane tabbedPaneView;
    private Map page2tab = new HashMap();
    private Map tab2Page = new HashMap();
    private boolean settingSelection;

    public TabbedDialogPage(String pageId) {
        super(pageId);
    }

    public TabbedDialogPage(String pageId, boolean autoConfigure) {
        super(pageId, autoConfigure);
    }

    protected JComponent createControl() {
        this.createPageControls();
        final JTabbedPane tabbedPane = this.getComponentFactory().createTabbedPane();
        this.tabbedPaneView = new ExtTabbedPane(tabbedPane);
        List pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            DialogPage page = (DialogPage)pages.get(i);
            Tab tab = new Tab();
            JComponent control = page.getControl();
            control.setPreferredSize(this.getLargestPageSize());
            tab.setComponent(control);
            tab.setVisible(page.isVisible());
            tab.setEnabled(page.isEnabled());
            this.decorateTab(tab, page);
            this.page2tab.put(page, tab);
            this.tab2Page.put(tab, page);
            this.tabbedPaneView.addTab(tab);
        }
        tabbedPane.setModel(new VetoableSingleSelectionModel(){

            protected boolean selectionAllowed(int index) {
                return TabbedDialogPage.this.canChangeTabs();
            }
        });
        this.tabbedPaneView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int index = tabbedPane.getSelectedIndex();
                if (index >= 0) {
                    index = TabbedDialogPage.this.tabbedPaneView.convertUIIndexToModelIndex(index);
                    Tab tab = TabbedDialogPage.this.tabbedPaneView.getTab(index);
                    TabbedDialogPage.this.setActivePage((DialogPage)TabbedDialogPage.this.tab2Page.get(tab));
                } else {
                    TabbedDialogPage.this.setActivePage(null);
                }
            }
        });
        this.setActivePage((DialogPage)pages.get(this.tabbedPaneView.convertUIIndexToModelIndex(0)));
        return tabbedPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivePage(DialogPage page) {
        if (this.settingSelection) {
            return;
        }
        try {
            this.settingSelection = true;
            super.setActivePage(page);
            if (page != null) {
                Tab tab = (Tab)this.page2tab.get(page);
                this.tabbedPaneView.selectTab(tab);
            }
        }
        finally {
            this.settingSelection = false;
        }
    }

    protected boolean canChangeTabs() {
        return true;
    }

    protected void updatePageComplete(DialogPage page) {
        super.updatePageComplete(page);
        if (this.tabbedPaneView != null) {
            Tab tab = (Tab)this.page2tab.get(page);
            this.decorateTab(tab, page);
        }
    }

    protected void decorateTab(Tab tab, DialogPage page) {
        tab.setTitle(this.getDecoratedPageTitle(page));
        tab.setTooltip(page.getDescription());
        if (page instanceof LabeledObjectSupport) {
            tab.setMnemonic(((LabeledObjectSupport)((Object)page)).getMnemonic());
        }
        tab.setIcon(page.getIcon());
    }

    protected void updatePageVisibility(DialogPage page) {
        Tab tab = this.getTab(page);
        tab.setVisible(page.isVisible());
    }

    protected void updatePageEnabled(DialogPage page) {
        Tab tab = this.getTab(page);
        tab.setEnabled(page.isEnabled());
    }

    protected void updatePageLabels(DialogPage page) {
        Tab tab = this.getTab(page);
        tab.setTitle(this.getDecoratedPageTitle(page));
    }

    protected final Tab getTab(DialogPage page) {
        return (Tab)this.page2tab.get(page);
    }
}

