/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.springframework.richclient.dialog.CompositeDialogPage;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.form.Form;
import org.springframework.richclient.layout.TableLayoutBuilder;
import org.springframework.richclient.tree.FocusableTreeCellRenderer;
import org.springframework.richclient.tree.TreeUtils;
import org.springframework.util.Assert;

public class TreeCompositeDialogPage
extends CompositeDialogPage {
    private static final DialogPage ROOT_PAGE = null;
    private final PageSelector pageSelector = new PageSelector();
    private final PageTitleCellRenderer treeCellRenderer = new PageTitleCellRenderer();
    private CardLayout cardLayout;
    private DefaultTreeModel pageTreeModel;
    private JPanel pagePanel;
    private JTree pageTree;
    private Map nodes = new HashMap();

    public TreeCompositeDialogPage(String pageId) {
        this(pageId, true);
    }

    public TreeCompositeDialogPage(String pageId, boolean autoConfigure) {
        super(pageId, autoConfigure);
        this.nodes.put(ROOT_PAGE, new DefaultMutableTreeNode("pages"));
    }

    public void addPage(DialogPage page) {
        this.addPage(ROOT_PAGE, page);
    }

    public DialogPage addForm(DialogPage parent, Form form) {
        DialogPage page = this.createDialogPage(form);
        this.addPage(parent, page);
        return page;
    }

    public void addPage(DialogPage parent, DialogPage child) {
        DefaultMutableTreeNode parentNode = this.getNode(parent);
        Assert.notNull((Object)parentNode, (String)"Parent dialog page must have been added before child");
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        parentNode.add(childNode);
        this.nodes.put(child, childNode);
        super.addPage(child);
        if (this.pageTreeModel != null) {
            this.pageTreeModel.nodeStructureChanged(parentNode);
        }
        if (this.pagePanel != null) {
            this.prepareDialogPage(child);
            this.processDialogPage(child);
        }
    }

    public void removePage(DialogPage page) {
        DefaultMutableTreeNode treeNode = this.getNode(page);
        TreeNode parentNode = treeNode.getParent();
        treeNode.removeFromParent();
        if (this.pagePanel != null) {
            JComponent control = page.getControl();
            this.pagePanel.remove(control);
        }
        if (this.pageTreeModel != null) {
            this.pageTreeModel.nodeStructureChanged(parentNode);
        }
    }

    public void addPages(DialogPage parent, DialogPage[] pages) {
        for (int i = 0; i < pages.length; ++i) {
            this.addPage(parent, pages[i]);
        }
    }

    public void expandAll(boolean expand) {
        if (!this.isControlCreated()) {
            this.getControl();
        }
        TreeUtils.expandAll(this.pageTree, expand);
    }

    public void expandLevels(int levels, boolean expand) {
        if (!this.isControlCreated()) {
            this.getControl();
        }
        TreeUtils.expandLevels(this.pageTree, levels, expand);
    }

    protected JComponent createControl() {
        this.createPageControls();
        this.cardLayout = new CardLayout();
        this.pagePanel = new JPanel(this.cardLayout);
        List pages = this.getPages();
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            DialogPage page = (DialogPage)i.next();
            this.processDialogPage(page);
        }
        DefaultMutableTreeNode rootNode = this.getNode(null);
        this.pageTreeModel = new DefaultTreeModel(rootNode);
        this.createTreeControl();
        this.pageTree.setModel(this.pageTreeModel);
        if (rootNode.getChildCount() > 0) {
            this.pageTree.setSelectionInterval(0, 0);
        }
        return this.createContentControl();
    }

    protected void processDialogPage(DialogPage page) {
        JComponent control = page.getControl();
        control.setPreferredSize(this.getLargestPageSize());
        this.pagePanel.add((Component)control, page.getId());
    }

    protected JPanel createContentControl() {
        TableLayoutBuilder panelBuilder = new TableLayoutBuilder();
        String colSpec = "colSpec=" + this.getTreeControlWidth() + " rowSpec=fill:default:grow";
        panelBuilder.cell(new JScrollPane(this.pageTree), colSpec);
        panelBuilder.gapCol();
        panelBuilder.cell(this.pagePanel, "valign=top");
        return panelBuilder.getPanel();
    }

    protected int getTreeControlWidth() {
        return 150;
    }

    protected void createTreeControl() {
        this.pageTree = new JTree();
        this.pageTree.setRootVisible(false);
        this.pageTree.getSelectionModel().setSelectionMode(1);
        this.pageTree.addTreeSelectionListener(this.pageSelector);
        this.pageTree.setCellRenderer(this.treeCellRenderer);
        this.pageTree.setShowsRootHandles(true);
    }

    protected void updatePageComplete(DialogPage page) {
        super.updatePageComplete(page);
        if (this.pageTreeModel != null) {
            this.pageTreeModel.nodeChanged(this.getNode(page));
        }
    }

    protected void updatePageLabels(DialogPage page) {
        if (this.pageTreeModel != null) {
            this.pageTreeModel.nodeChanged(this.getNode(page));
        }
    }

    protected DefaultMutableTreeNode getNode(DialogPage page) {
        return (DefaultMutableTreeNode)this.nodes.get(page);
    }

    protected Map getNodes() {
        return this.nodes;
    }

    protected JTree getPageTree() {
        return this.pageTree;
    }

    protected JPanel getPagePanel() {
        return this.pagePanel;
    }

    protected DefaultTreeModel getPageTreeModel() {
        return this.pageTreeModel;
    }

    protected class PageSelector
    implements TreeSelectionListener {
        private TreePath currentSelection;

        protected PageSelector() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreeCompositeDialogPage.this.pageTree.getLastSelectedPathComponent();
            if (node == null) {
                TreeCompositeDialogPage.this.pageTree.setSelectionPath(this.currentSelection);
                return;
            }
            this.currentSelection = e.getPath();
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            DialogPage activePage = (DialogPage)selectedNode.getUserObject();
            TreeCompositeDialogPage.this.cardLayout.show(TreeCompositeDialogPage.this.pagePanel, activePage.getId());
            TreeCompositeDialogPage.this.setActivePage(activePage);
        }
    }

    protected class PageTitleCellRenderer
    extends FocusableTreeCellRenderer {
        protected PageTitleCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof DialogPage) {
                DialogPage page = (DialogPage)node.getUserObject();
                this.setText(TreeCompositeDialogPage.this.getDecoratedPageTitle(page));
                this.setIcon(page.getIcon());
            }
            return this;
        }
    }
}

