/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.factory;

import javax.swing.JComponent;
import org.springframework.richclient.application.support.ApplicationServicesAccessor;
import org.springframework.richclient.factory.ControlFactory;

public abstract class AbstractControlFactory
extends ApplicationServicesAccessor
implements ControlFactory {
    private boolean singleton = true;
    private JComponent control;

    protected AbstractControlFactory() {
    }

    protected final boolean isSingleton() {
        return this.singleton;
    }

    protected final void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public final JComponent getControl() {
        if (this.isSingleton()) {
            if (this.control == null) {
                this.control = this.createControl();
            }
            return this.control;
        }
        return this.createControl();
    }

    public final boolean isControlCreated() {
        if (this.isSingleton()) {
            return this.control != null;
        }
        return false;
    }

    protected void createControlIfNecessary() {
        if (this.isSingleton() && this.control == null) {
            this.getControl();
        }
    }

    protected abstract JComponent createControl();
}

