/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.springframework.binding.form.CommitListener;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.validation.ValidationListener;
import org.springframework.binding.value.IndexAdapter;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.form.Form;
import org.springframework.richclient.form.FormGuard;
import org.springframework.richclient.form.FormModelHelper;
import org.springframework.richclient.form.SimpleValidationResultsReporter;
import org.springframework.richclient.form.ValidationResultsReporter;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.binding.BindingFactoryProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractForm
extends AbstractControlFactory
implements Form,
CommitListener {
    private final FormObjectChangeHandler formObjectChangeHandler = new FormObjectChangeHandler();
    private String formId;
    private ValidatingFormModel formModel;
    private HierarchicalFormModel parentFormModel;
    private FormGuard formGuard;
    private JButton lastDefaultButton;
    private PropertyChangeListener formEnabledChangeHandler;
    private ActionCommand newFormObjectCommand;
    private ActionCommand commitCommand;
    private ActionCommand revertCommand;
    private boolean editingNewFormObject;
    private boolean clearFormOnCommit = false;
    private ObservableList editableFormObjects;
    private ValueModel editingFormObjectIndexHolder;
    private PropertyChangeListener editingFormObjectSetter;
    private BindingFactory bindingFactory;
    private Map childForms = new HashMap();
    private List validationResultsReporters = new ArrayList();

    protected AbstractForm() {
        this.setId(StringUtils.uncapitalize((String)this.getClass().getSimpleName()));
        this.init();
    }

    protected AbstractForm(String formId) {
        this.setId(formId);
        this.init();
    }

    protected AbstractForm(Object formObject) {
        this((FormModel)FormModelHelper.createFormModel(formObject));
    }

    protected AbstractForm(FormModel formModel) {
        this(formModel, formModel.getId());
    }

    protected AbstractForm(FormModel formModel, String formId) {
        this.setId(formId);
        if (!(formModel instanceof ValidatingFormModel)) {
            throw new IllegalArgumentException("Unsupported form model implementation " + formModel);
        }
        this.setFormModel((ValidatingFormModel)formModel);
        this.init();
    }

    protected AbstractForm(HierarchicalFormModel parentFormModel, String formId, String childFormObjectPropertyPath) {
        this.setId(formId);
        this.parentFormModel = parentFormModel;
        this.setFormModel(FormModelHelper.createChildPageFormModel(parentFormModel, formId, childFormObjectPropertyPath));
        this.init();
    }

    protected AbstractForm(HierarchicalFormModel parentFormModel, String formId, ValueModel childFormObjectHolder) {
        this.setId(formId);
        this.parentFormModel = parentFormModel;
        this.setFormModel(FormModelHelper.createChildPageFormModel(parentFormModel, formId, childFormObjectHolder));
        this.init();
    }

    protected void init() {
    }

    public String getId() {
        return this.formId;
    }

    protected void setId(String formId) {
        this.formId = formId;
    }

    public ValidatingFormModel getFormModel() {
        return this.formModel;
    }

    public BindingFactory getBindingFactory() {
        if (this.bindingFactory == null) {
            this.bindingFactory = ((BindingFactoryProvider)this.getService(BindingFactoryProvider.class)).getBindingFactory((FormModel)this.formModel);
        }
        return this.bindingFactory;
    }

    protected void setFormModel(ValidatingFormModel formModel) {
        Assert.notNull((Object)formModel);
        if (this.formModel != null && this.isControlCreated()) {
            throw new UnsupportedOperationException("Cannot reset form model once form control has been created");
        }
        if (this.formModel != null) {
            this.formModel.removeCommitListener((CommitListener)this);
        }
        this.formModel = formModel;
        this.formGuard = new FormGuard(formModel);
        this.formModel.addCommitListener((CommitListener)this);
        this.setFormModelDefaultEnabledState();
    }

    protected HierarchicalFormModel getParent() {
        return this.parentFormModel;
    }

    public void addChildForm(Form childForm) {
        this.childForms.put(childForm.getId(), childForm);
        this.getFormModel().addChild((HierarchicalFormModel)childForm.getFormModel());
    }

    public List getValidationResultsReporters() {
        return this.validationResultsReporters;
    }

    public void addValidationResultsReporter(ValidationResultsReporter reporter) {
        this.validationResultsReporters.add(reporter);
    }

    public void removeValidationResultsReporter(ValidationResultsReporter reporter) {
        this.validationResultsReporters.remove(reporter);
    }

    public void removeChildForm(Form childForm) {
        this.getFormModel().removeChild((HierarchicalFormModel)childForm.getFormModel());
        this.childForms.remove(childForm.getId());
    }

    protected Form getChildForm(String id) {
        return (Form)this.childForms.get(id);
    }

    protected void setEditableFormObjects(ObservableList editableFormObjects) {
        this.editableFormObjects = editableFormObjects;
    }

    protected void setEditingFormObjectIndexHolder(ValueModel valueModel) {
        this.editingFormObjectIndexHolder = valueModel;
        this.editingFormObjectSetter = new EditingFormObjectSetter();
        this.editingFormObjectIndexHolder.addValueChangeListener(this.editingFormObjectSetter);
    }

    public boolean isEditingNewFormObject() {
        return this.editingNewFormObject;
    }

    protected void setEditingNewFormObject(boolean editingNewFormOject) {
        this.editingNewFormObject = editingNewFormOject;
    }

    protected int getEditingFormObjectIndex() {
        return (Integer)this.editingFormObjectIndexHolder.getValue();
    }

    protected Object getEditableFormObject(int selectionIndex) {
        return this.editableFormObjects.get(selectionIndex);
    }

    public void setClearFormOnCommit(boolean clearFormOnCommit) {
        this.clearFormOnCommit = clearFormOnCommit;
    }

    protected JButton getDefaultButton() {
        if (this.isControlCreated()) {
            JRootPane rootPane = SwingUtilities.getRootPane(this.getControl());
            return rootPane == null ? null : rootPane.getDefaultButton();
        }
        return null;
    }

    protected void setDefaultButton(JButton button) {
        JRootPane rootPane = SwingUtilities.getRootPane(this.getControl());
        if (rootPane != null) {
            rootPane.setDefaultButton(button);
        }
    }

    protected final JComponent createControl() {
        Assert.state((this.getFormModel() != null ? 1 : 0) != 0, (String)"This form's FormModel cannot be null once control creation is triggered!");
        this.initStandardLocalFormCommands();
        JComponent formControl = this.createFormControl();
        this.formEnabledChangeHandler = new FormEnabledPropertyChangeHandler();
        this.getFormModel().addPropertyChangeListener("enabled", this.formEnabledChangeHandler);
        this.addFormObjectChangeListener(this.formObjectChangeHandler);
        if (this.getCommitCommand() != null) {
            this.getFormModel().addCommitListener((CommitListener)this);
        }
        return formControl;
    }

    private void initStandardLocalFormCommands() {
        this.getNewFormObjectCommand();
        this.getCommitCommand();
        this.getRevertCommand();
    }

    protected void setFormModelDefaultEnabledState() {
        if (this.getFormObject() == null) {
            this.getFormModel().setEnabled(false);
        } else if (this.getFormObject() instanceof Guarded) {
            this.setEnabled(((Guarded)this.getFormObject()).isEnabled());
        }
    }

    protected abstract JComponent createFormControl();

    protected void handleEnabledChange(boolean enabled) {
        if (enabled) {
            if (this.getCommitCommand() != null) {
                if (this.lastDefaultButton == null) {
                    this.lastDefaultButton = this.getDefaultButton();
                }
                this.getCommitCommand().setDefaultButton();
            }
        } else {
            if (this.getCommitCommand() != null) {
                this.getCommitCommand().setEnabled(false);
            }
            if (this.lastDefaultButton != null) {
                this.setDefaultButton(this.lastDefaultButton);
            }
        }
    }

    public ActionCommand getNewFormObjectCommand() {
        if (this.newFormObjectCommand == null) {
            this.newFormObjectCommand = this.createNewFormObjectCommand();
        }
        return this.newFormObjectCommand;
    }

    public ActionCommand getCommitCommand() {
        if (this.commitCommand == null) {
            this.commitCommand = this.createCommitCommand();
        }
        return this.commitCommand;
    }

    public ActionCommand getRevertCommand() {
        if (this.revertCommand == null) {
            this.revertCommand = this.createRevertCommand();
        }
        return this.revertCommand;
    }

    private ActionCommand createNewFormObjectCommand() {
        String commandId = this.getNewFormObjectCommandId();
        if (!StringUtils.hasText((String)commandId)) {
            return null;
        }
        ActionCommand newFormObjectCmd = new ActionCommand(commandId){

            protected void doExecuteCommand() {
                AbstractForm.this.getFormModel().setFormObject(AbstractForm.this.createNewObject());
                AbstractForm.this.getFormModel().setEnabled(true);
                AbstractForm.this.editingNewFormObject = true;
                if (AbstractForm.this.isEditingFormObjectSelected()) {
                    AbstractForm.this.setEditingFormObjectIndexSilently(-1);
                }
            }
        };
        newFormObjectCmd.setSecurityControllerId(this.getNewFormObjectSecurityControllerId());
        this.attachFormGuard(newFormObjectCmd, 4);
        return (ActionCommand)this.getCommandConfigurer().configure(newFormObjectCmd);
    }

    protected Object createNewObject() {
        return null;
    }

    private boolean isEditingFormObjectSelected() {
        if (this.editingFormObjectIndexHolder == null) {
            return false;
        }
        int value = (Integer)this.editingFormObjectIndexHolder.getValue();
        return value != -1;
    }

    protected void setEditingFormObjectIndexSilently(int index) {
        this.editingFormObjectIndexHolder.removeValueChangeListener(this.editingFormObjectSetter);
        this.editingFormObjectIndexHolder.setValue((Object)new Integer(index));
        this.editingFormObjectIndexHolder.addValueChangeListener(this.editingFormObjectSetter);
    }

    private final ActionCommand createCommitCommand() {
        String commandId = this.getCommitCommandFaceDescriptorId();
        if (!StringUtils.hasText((String)commandId)) {
            return null;
        }
        ActionCommand commitCmd = new ActionCommand(commandId){

            protected void doExecuteCommand() {
                AbstractForm.this.commit();
            }
        };
        commitCmd.setSecurityControllerId(this.getCommitSecurityControllerId());
        this.attachFormGuard(commitCmd, 7);
        return (ActionCommand)this.getCommandConfigurer().configure(commitCmd);
    }

    public void preCommit(FormModel formModel) {
    }

    public void postCommit(FormModel formModel) {
        if (this.editableFormObjects != null) {
            if (this.editingNewFormObject) {
                this.editableFormObjects.add(formModel.getFormObject());
                this.setEditingFormObjectIndexSilently(this.editableFormObjects.size() - 1);
            } else {
                int index = this.getEditingFormObjectIndex();
                if (index >= 0) {
                    IndexAdapter adapter = this.editableFormObjects.getIndexAdapter(index);
                    adapter.setValue(formModel.getFormObject());
                    adapter.fireIndexedObjectChanged();
                }
            }
        }
        if (this.clearFormOnCommit) {
            this.setFormObject(null);
        }
        this.editingNewFormObject = false;
    }

    private final ActionCommand createRevertCommand() {
        String commandId = this.getRevertCommandFaceDescriptorId();
        if (!StringUtils.hasText((String)commandId)) {
            return null;
        }
        ActionCommand revertCmd = new ActionCommand(commandId){

            protected void doExecuteCommand() {
                AbstractForm.this.revert();
            }
        };
        this.attachFormGuard(revertCmd, 6);
        return (ActionCommand)this.getCommandConfigurer().configure(revertCmd);
    }

    protected final JButton createNewFormObjectButton() {
        Assert.state((this.newFormObjectCommand != null ? 1 : 0) != 0, (String)"New form object command has not been created!");
        return (JButton)this.newFormObjectCommand.createButton();
    }

    protected final JButton createCommitButton() {
        Assert.state((this.commitCommand != null ? 1 : 0) != 0, (String)"Commit command has not been created!");
        return (JButton)this.commitCommand.createButton();
    }

    protected String getNewFormObjectCommandId() {
        return "new" + StringUtils.capitalize((String)ClassUtils.getShortName((String)(this.getFormModel().getFormObject().getClass() + "Command")));
    }

    protected String getCommitCommandFaceDescriptorId() {
        return null;
    }

    protected String getRevertCommandFaceDescriptorId() {
        return null;
    }

    protected String getNewFormObjectSecurityControllerId() {
        return this.constructSecurityControllerId(this.getNewFormObjectCommandId());
    }

    protected String getCommitSecurityControllerId() {
        return this.constructSecurityControllerId(this.getCommitCommandFaceDescriptorId());
    }

    protected String constructSecurityControllerId(String commandFaceId) {
        String id = null;
        String formModelId = this.getFormModel().getId();
        if (commandFaceId != null) {
            id = formModelId != null ? formModelId + "." + commandFaceId : commandFaceId;
        }
        return id;
    }

    protected void attachFormErrorGuard(Guarded guarded) {
        this.attachFormGuard(guarded, 5);
    }

    protected void attachFormGuard(Guarded guarded, int mask) {
        this.formGuard.addGuarded(guarded, mask);
    }

    protected void detachFormGuard(Guarded guarded) {
        this.formGuard.removeGuarded(guarded);
    }

    public Object getFormObject() {
        return this.formModel.getFormObject();
    }

    public void setFormObject(Object formObject) {
        this.formModel.setFormObject(formObject);
    }

    public Object getValue(String formProperty) {
        return this.formModel.getValueModel(formProperty).getValue();
    }

    public ValueModel getValueModel(String formProperty) {
        ValueModel valueModel = this.formModel.getValueModel(formProperty);
        if (valueModel == null) {
            this.logger.warn((Object)("A value model for property '" + formProperty + "' could not be found.  Typo?"));
        }
        return valueModel;
    }

    public boolean isEnabled() {
        return this.formModel.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.formModel.setEnabled(enabled);
    }

    public void addValidationListener(ValidationListener listener) {
        this.formModel.getValidationResults().addValidationListener(listener);
    }

    public void removeValidationListener(ValidationListener listener) {
        this.formModel.getValidationResults().removeValidationListener(listener);
    }

    public ValidationResultsReporter newSingleLineResultsReporter(Messagable messageReceiver) {
        SimpleValidationResultsReporter reporter = new SimpleValidationResultsReporter(this.formModel.getValidationResults(), messageReceiver);
        return reporter;
    }

    public void addFormObjectChangeListener(PropertyChangeListener listener) {
        this.formModel.getFormObjectHolder().addValueChangeListener(listener);
    }

    public void removeFormObjectChangeListener(PropertyChangeListener listener) {
        this.formModel.getFormObjectHolder().removeValueChangeListener(listener);
    }

    public void addFormValueChangeListener(String formPropertyPath, PropertyChangeListener listener) {
        this.getFormModel().getValueModel(formPropertyPath).addValueChangeListener(listener);
    }

    public void removeFormValueChangeListener(String formPropertyPath, PropertyChangeListener listener) {
        this.getFormModel().getValueModel(formPropertyPath).removeValueChangeListener(listener);
    }

    public boolean isDirty() {
        return this.formModel.isDirty();
    }

    public boolean hasErrors() {
        return this.formModel.getValidationResults().getHasErrors();
    }

    public void commit() {
        this.formModel.commit();
    }

    public void revert() {
        this.formModel.revert();
    }

    public void reset() {
        this.getFormModel().reset();
    }

    public void addGuarded(Guarded guarded) {
        this.formGuard.addGuarded(guarded, 5);
    }

    public void addGuarded(Guarded guarded, int mask) {
        this.formGuard.addGuarded(guarded, mask);
    }

    public void removeGuarded(Guarded guarded) {
        this.formGuard.removeGuarded(guarded);
    }

    private class FormEnabledPropertyChangeHandler
    implements PropertyChangeListener {
        public FormEnabledPropertyChangeHandler() {
            AbstractForm.this.handleEnabledChange(AbstractForm.this.getFormModel().isEnabled());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractForm.this.handleEnabledChange(AbstractForm.this.getFormModel().isEnabled());
        }
    }

    private class FormObjectChangeHandler
    implements PropertyChangeListener {
        private FormObjectChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractForm.this.setFormModelDefaultEnabledState();
        }
    }

    private class EditingFormObjectSetter
    implements PropertyChangeListener {
        private EditingFormObjectSetter() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int selectionIndex = AbstractForm.this.getEditingFormObjectIndex();
            if (selectionIndex == -1) {
                AbstractForm.this.setEnabled(false);
            } else if (selectionIndex < AbstractForm.this.editableFormObjects.size()) {
                AbstractForm.this.setEditingNewFormObject(false);
                AbstractForm.this.setFormObject(AbstractForm.this.getEditableFormObject(selectionIndex));
                AbstractForm.this.setEnabled(true);
            }
        }
    }
}

