/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.form.support.DefaultFormModel;
import org.springframework.binding.validation.Validator;
import org.springframework.binding.validation.support.RulesValidator;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.SimpleValidationResultsReporter;
import org.springframework.richclient.form.ValidationResultsReporter;
import org.springframework.rules.RulesSource;

public class FormModelHelper {
    public static ValidatingFormModel createFormModel(Object formObject, String formId) {
        return FormModelHelper.createFormModel(formObject, true, formId);
    }

    public static ValidatingFormModel createUnbufferedFormModel(Object formObject, String formId) {
        return FormModelHelper.createFormModel(formObject, false, formId);
    }

    public static ValidatingFormModel createFormModel(Object formObject, boolean bufferChanges, String formId) {
        DefaultFormModel formModel = new DefaultFormModel(formObject, bufferChanges);
        formModel.setId(formId);
        return formModel;
    }

    public static ValidatingFormModel createFormModel(Object formObject, boolean bufferChanges, RulesSource rulesSource, String formId) {
        DefaultFormModel formModel = new DefaultFormModel(formObject, bufferChanges);
        formModel.setId(formId);
        formModel.setValidator((Validator)new RulesValidator((FormModel)formModel, rulesSource));
        return formModel;
    }

    public static ValidatingFormModel createCompoundFormModel(Object formObject, String formId) {
        DefaultFormModel model = new DefaultFormModel(formObject);
        model.setId(formId);
        return model;
    }

    public static ValidatingFormModel createFormModel(ValueModel formObjectHolder) {
        return FormModelHelper.createFormModel(formObjectHolder, true, null);
    }

    public static ValidatingFormModel createFormModel(ValueModel formObjectHolder, String formId) {
        return FormModelHelper.createFormModel(formObjectHolder, true, formId);
    }

    public static ValidatingFormModel createUnbufferedFormModel(ValueModel formObjectHolder, String formId) {
        return FormModelHelper.createFormModel(formObjectHolder, false, formId);
    }

    public static ValidatingFormModel createFormModel(ValueModel formObjectHolder, boolean bufferChanges, String formId) {
        DefaultFormModel formModel = new DefaultFormModel(formObjectHolder, bufferChanges);
        formModel.setId(formId);
        return formModel;
    }

    public static ValidatingFormModel createCompoundFormModel(ValueModel formObjectHolder, String formId) {
        DefaultFormModel model = new DefaultFormModel(formObjectHolder);
        model.setId(formId);
        return model;
    }

    public static ValidatingFormModel createFormModel(Object formObject) {
        return FormModelHelper.createFormModel(formObject, true);
    }

    public static ValidatingFormModel createUnbufferedFormModel(Object formObject) {
        return FormModelHelper.createFormModel(formObject, false);
    }

    public static ValidatingFormModel createFormModel(Object formObject, boolean bufferChanges) {
        return FormModelHelper.createFormModel(formObject, bufferChanges, null);
    }

    public static HierarchicalFormModel createCompoundFormModel(Object formObject) {
        return FormModelHelper.createCompoundFormModel(formObject, null);
    }

    public static FormModel createChildPageFormModel(HierarchicalFormModel parentModel) {
        return FormModelHelper.createChildPageFormModel(parentModel, null);
    }

    public static ValidatingFormModel createChildPageFormModel(HierarchicalFormModel parentModel, String childPageName) {
        ValidatingFormModel child = FormModelHelper.createFormModel(parentModel.getFormObjectHolder());
        child.setId(childPageName);
        parentModel.addChild((HierarchicalFormModel)child);
        return child;
    }

    public static ValidatingFormModel createChildPageFormModel(HierarchicalFormModel parentModel, String childPageName, String childFormObjectPropertyPath) {
        ValueModel childValueModel = parentModel.getValueModel(childFormObjectPropertyPath);
        return FormModelHelper.createChildPageFormModel(parentModel, childPageName, childValueModel);
    }

    public static ValidatingFormModel createChildPageFormModel(HierarchicalFormModel parentModel, String childPageName, ValueModel childFormObjectHolder) {
        ValidatingFormModel child = FormModelHelper.createFormModel(childFormObjectHolder);
        child.setId(childPageName);
        parentModel.addChild((HierarchicalFormModel)child);
        return child;
    }

    public static ValidationResultsReporter createSingleLineResultsReporter(ValidatingFormModel formModel, Messagable messageReceiver) {
        return new SimpleValidationResultsReporter(formModel.getValidationResults(), messageReceiver);
    }

    public static FormModel getChild(HierarchicalFormModel formModel, String childPageName) {
        if (childPageName == null) {
            throw new IllegalArgumentException("childPageName == null");
        }
        if (formModel == null) {
            throw new IllegalArgumentException("formModel == null");
        }
        FormModel[] children = formModel.getChildren();
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.length; ++i) {
            FormModel child = children[i];
            if (!childPageName.equals(child.getId())) continue;
            return child;
        }
        return null;
    }
}

