/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.springframework.binding.form.FieldFace;
import org.springframework.binding.form.FieldMetadata;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.util.Assert;

public abstract class AbstractBinding
extends AbstractControlFactory
implements Binding {
    protected final FormModel formModel;
    protected final String formPropertyPath;
    protected final FieldMetadata fieldMetadata;
    private final FieldMetadataChangeHandler fieldMetadataChangeHandler = new FieldMetadataChangeHandler();
    private final Class requiredSourceClass;

    protected AbstractBinding(FormModel formModel, String formPropertyPath, Class requiredSourceClass) {
        this.formModel = formModel;
        this.formPropertyPath = formPropertyPath;
        this.fieldMetadata = this.formModel.getFieldMetadata(formPropertyPath);
        this.requiredSourceClass = requiredSourceClass;
        this.fieldMetadata.addPropertyChangeListener("enabled", (PropertyChangeListener)this.fieldMetadataChangeHandler);
        this.fieldMetadata.addPropertyChangeListener("readOnly", (PropertyChangeListener)this.fieldMetadataChangeHandler);
    }

    public String getProperty() {
        return this.formPropertyPath;
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    protected FieldFace getFieldFace() {
        return this.formModel.getFieldFace(this.formPropertyPath);
    }

    protected Class getPropertyType() {
        return this.fieldMetadata.getPropertyType();
    }

    protected JComponent createControl() {
        JComponent control = this.doBindControl();
        control.setName(this.getProperty());
        this.readOnlyChanged();
        this.enabledChanged();
        return control;
    }

    protected abstract JComponent doBindControl();

    protected abstract void readOnlyChanged();

    protected abstract void enabledChanged();

    protected boolean isReadOnly() {
        return this.fieldMetadata.isReadOnly();
    }

    protected boolean isEnabled() {
        return this.fieldMetadata.isEnabled();
    }

    protected ValueModel getValueModel() {
        ValueModel valueModel = this.requiredSourceClass == null ? this.formModel.getValueModel(this.formPropertyPath) : this.formModel.getValueModel(this.formPropertyPath, this.requiredSourceClass);
        Assert.notNull((Object)valueModel, (String)("Unable to locate value model for property '" + this.formPropertyPath + "'."));
        return valueModel;
    }

    protected Object getValue() {
        return this.getValueModel().getValue();
    }

    private class FieldMetadataChangeHandler
    implements PropertyChangeListener {
        private FieldMetadataChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                AbstractBinding.this.enabledChanged();
            } else if ("readOnly".equals(evt.getPropertyName())) {
                AbstractBinding.this.readOnlyChanged();
            }
        }
    }
}

