/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.springframework.binding.form.FormModel;
import org.springframework.core.closure.Closure;
import org.springframework.richclient.form.binding.swing.AbstractListBinder;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.richclient.form.binding.swing.ComboBoxBinding;
import org.springframework.util.Assert;

public class ComboBoxBinder
extends AbstractListBinder {
    public static final String RENDERER_KEY = "renderer";
    public static final String EDITOR_KEY = "editor";
    public static final String EMPTY_SELECTION_VALUE = "emptySelectionValue";
    private Object renderer;
    private Object editor;
    private Object emptySelectionValue;

    public ComboBoxBinder() {
        this(null, new String[]{"selectableItems", "comparator", RENDERER_KEY, EDITOR_KEY, "filter", EMPTY_SELECTION_VALUE});
    }

    public ComboBoxBinder(String[] supportedContextKeys) {
        this(null, supportedContextKeys);
    }

    public ComboBoxBinder(Class requiredSourceClass, String[] supportedContextKeys) {
        super(requiredSourceClass, supportedContextKeys);
    }

    protected AbstractListBinding createListBinding(JComponent control, FormModel formModel, String formPropertyPath) {
        Assert.isInstanceOf((Class)JComboBox.class, (Object)control, (String)formPropertyPath);
        return new ComboBoxBinding((JComboBox)control, formModel, formPropertyPath, this.getRequiredSourceClass());
    }

    protected void applyContext(AbstractListBinding binding, Map context) {
        super.applyContext(binding, context);
        ComboBoxBinding comboBoxBinding = (ComboBoxBinding)binding;
        if (context.containsKey(RENDERER_KEY)) {
            comboBoxBinding.setRenderer((ListCellRenderer)this.decorate(context.get(RENDERER_KEY), comboBoxBinding.getRenderer()));
        } else if (this.renderer != null) {
            comboBoxBinding.setRenderer((ListCellRenderer)this.decorate(this.renderer, comboBoxBinding.getRenderer()));
        }
        if (context.containsKey(EDITOR_KEY)) {
            comboBoxBinding.setEditor((ComboBoxEditor)this.decorate(context.get(EDITOR_KEY), comboBoxBinding.getEditor()));
        } else if (this.editor != null) {
            comboBoxBinding.setEditor((ComboBoxEditor)this.decorate(this.editor, comboBoxBinding.getEditor()));
        }
        if (context.containsKey(EMPTY_SELECTION_VALUE)) {
            comboBoxBinding.setEmptySelectionValue(context.get(EMPTY_SELECTION_VALUE));
        } else if (this.emptySelectionValue != null) {
            comboBoxBinding.setEmptySelectionValue(this.emptySelectionValue);
        }
    }

    protected JComponent createControl(Map context) {
        return this.getComponentFactory().createComboBox();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
    }

    public void setRendererClosure(Closure rendererClosure) {
        this.renderer = rendererClosure;
    }

    public void setEditor(ComboBoxEditor editor) {
        this.editor = editor;
    }

    public void setEditorClosure(Closure editorClosure) {
        this.editor = editorClosure;
    }

    public Object getEmptySelectionValue() {
        return this.emptySelectionValue;
    }

    public void setEmptySelectionValue(Object emptySelectionValue) {
        this.emptySelectionValue = emptySelectionValue;
    }
}

