/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import [Ljava.lang.Object;;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.util.Assert;

public class ListBinding
extends AbstractListBinding {
    private static final Object[] EMPTY_VALUES = new Object[0];
    private final ListSelectionListener selectionListener = new SelectionListener();
    private final PropertyChangeListener valueModelListener = new ValueModelListener();
    private ConversionExecutor conversionExecutor;
    boolean selectingValues;

    public ListBinding(JList list, FormModel formModel, String formFieldPath, Class requiredSourceClass) {
        super(list, formModel, formFieldPath, requiredSourceClass);
    }

    public JList getList() {
        return (JList)this.getComponent();
    }

    public void setSelectionMode(int selectionMode) {
        Assert.isTrue((0 == selectionMode || this.isPropertyConversionExecutorAvailable() ? 1 : 0) != 0);
        this.getList().setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.getList().getSelectionMode();
    }

    protected ConversionExecutor getPropertyConversionExecutor() {
        if (this.conversionExecutor == null) {
            this.conversionExecutor = this.getConversionService().getConversionExecutor(Object;.class, this.getPropertyType());
        }
        return this.conversionExecutor;
    }

    protected boolean isPropertyConversionExecutorAvailable() {
        try {
            this.getConversionService().getConversionExecutor(Object;.class, this.getPropertyType());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    protected void updateSelectedItemsFromSelectionModel() {
        if (this.getSelectionMode() == 0) {
            Object singleValue = this.getList().getSelectedValue();
            Class propertyType = this.getPropertyType();
            if (singleValue == null || propertyType.isAssignableFrom(singleValue.getClass())) {
                this.getValueModel().setValueSilently(singleValue, this.valueModelListener);
            } else {
                this.getValueModel().setValueSilently(this.convertValue(singleValue, propertyType), this.valueModelListener);
            }
        } else {
            Object[] values = this.getList().getSelectedValues();
            this.getValueModel().setValueSilently(this.convertSelectedValues(values), this.valueModelListener);
        }
    }

    protected Object convertSelectedValues(Object[] selectedValues) {
        return this.getPropertyConversionExecutor().execute((Object)selectedValues);
    }

    protected void doBindControl(ListModel bindingModel) {
        JList list = this.getList();
        list.setModel(bindingModel);
        list.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.getValueModel().addValueChangeListener(this.valueModelListener);
        if (!this.isPropertyConversionExecutorAvailable() && this.getSelectionMode() != 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Selection mode for list field " + this.getProperty() + " forced to single selection." + " If multiple selection is needed use a collection type (List, Collection, Object[])" + " or provide a suitable converter to convert Object[] instances to property type " + this.getPropertyType()));
            }
            this.setSelectionMode(0);
        }
        this.updateSelectedItemsFromValueModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelectedItemsFromValueModel() {
        Object value = this.getValue();
        Object[] selectedValues = EMPTY_VALUES;
        if (value != null) {
            selectedValues = (Object[])this.convertValue(value, Object;.class);
        }
        this.selectingValues = true;
        try {
            ListSelectionModel selectionModel = this.getList().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                int[] valueIndexes = this.determineValueIndexes(selectedValues);
                int selectionMode = this.getSelectionMode();
                if (selectionMode == 0 && valueIndexes.length > 1) {
                    this.getList().setSelectedIndex(valueIndexes[0]);
                } else {
                    this.getList().setSelectedIndices(valueIndexes);
                }
                if (valueIndexes.length != selectedValues.length && !this.isReadOnly() && this.isEnabled() || selectionMode == 0 && valueIndexes.length > 1) {
                    this.updateSelectedItemsFromSelectionModel();
                }
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
        finally {
            this.selectingValues = false;
        }
    }

    protected int[] determineValueIndexes(Object[] values) {
        int[] result;
        int[] indexes = new int[values.length];
        if (values.length == 0) {
            return indexes;
        }
        HashSet<Object> lookupValues = new HashSet<Object>(Arrays.asList(values));
        ListModel model = this.getList().getModel();
        int i = 0;
        int size = model.getSize();
        for (int index = 0; index < size && !lookupValues.isEmpty(); ++index) {
            if (!lookupValues.remove(model.getElementAt(index))) continue;
            indexes[i++] = index;
        }
        if (i != values.length) {
            result = new int[i];
            System.arraycopy(indexes, 0, result, 0, i);
        } else {
            result = indexes;
        }
        return result;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.getList().setCellRenderer(renderer);
    }

    public ListCellRenderer getRenderer() {
        return this.getList().getCellRenderer();
    }

    protected ListModel getDefaultModel() {
        return this.getList().getModel();
    }

    protected class ValueModelListener
    implements PropertyChangeListener {
        protected ValueModelListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ListBinding.this.updateSelectedItemsFromValueModel();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!ListBinding.this.selectingValues && !e.getValueIsAdjusting()) {
                ListBinding.this.updateSelectedItemsFromSelectionModel();
            }
        }
    }
}

