/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.binding.form.ConfigurableFormModel;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.support.DefaultFormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.BufferedCollectionValueModel;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.core.closure.Closure;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBindingFactory;
import org.springframework.richclient.list.BeanPropertyValueComboBoxEditor;
import org.springframework.richclient.list.BeanPropertyValueListRenderer;
import org.springframework.util.Assert;

public class SwingBindingFactory
extends AbstractBindingFactory {
    static /* synthetic */ Class class$javax$swing$ComboBoxEditor;

    public SwingBindingFactory(FormModel formModel) {
        super(formModel);
    }

    public Binding createBoundTextField(String formProperty) {
        return this.createBinding(JTextField.class, formProperty);
    }

    public Binding createBoundTextArea(String formProperty) {
        return this.createBinding(JTextArea.class, formProperty);
    }

    public Binding createBoundTextArea(String formProperty, int rows, int columns) {
        Map context = this.createContext("rows", new Integer(rows));
        context.put("columns", new Integer(columns));
        return this.createBinding(JTextArea.class, formProperty, context);
    }

    public Binding createBoundFormattedTextField(String formProperty) {
        return this.createBinding(JFormattedTextField.class, formProperty);
    }

    public Binding createBoundFormattedTextField(String formProperty, JFormattedTextField.AbstractFormatterFactory formatterFactory) {
        Map context = this.createContext("formatterFactory", formatterFactory);
        return this.createBinding(JFormattedTextField.class, formProperty, context);
    }

    public Binding createBoundSpinner(String formProperty) {
        return this.createBinding(JSpinner.class, formProperty);
    }

    public Binding createBoundLabel(String formProperty) {
        return this.createBinding(JLabel.class, formProperty);
    }

    public Binding createBoundToggleButton(String formProperty) {
        return this.createBinding(JToggleButton.class, formProperty);
    }

    public Binding createBoundCheckBox(String formProperty) {
        return this.createBinding(JCheckBox.class, formProperty);
    }

    public Binding createBoundComboBox(String formProperty) {
        return this.createBinding(JComboBox.class, formProperty);
    }

    public Binding createBoundComboBox(String formProperty, Object selectableItems) {
        Map context = this.createContext("selectableItems", selectableItems);
        return this.createBinding(JComboBox.class, formProperty, context);
    }

    public Binding createBoundComboBox(String formProperty, ValueModel selectableItemsHolder) {
        return this.createBoundComboBox(formProperty, (Object)selectableItemsHolder);
    }

    public Binding createBoundComboBox(String formProperty, String selectableItemsProperty, String renderedItemProperty) {
        return this.createBoundComboBox(formProperty, this.getFormModel().getValueModel(selectableItemsProperty), renderedItemProperty);
    }

    public Binding createBoundComboBox(String formProperty, Object selectableItems, String renderedProperty) {
        Map context = this.createContext("selectableItems", selectableItems);
        context.put("renderer", new BeanPropertyValueListRenderer(renderedProperty));
        context.put("editor", new BeanPropertyEditorClosure(renderedProperty));
        context.put("comparator", new PropertyComparator(renderedProperty, true, true));
        return this.createBinding(JComboBox.class, formProperty, context);
    }

    public Binding createBoundComboBox(String formProperty, ValueModel selectableItemsHolder, String renderedProperty) {
        return this.createBoundComboBox(formProperty, (Object)selectableItemsHolder, renderedProperty);
    }

    public ObservableList createBoundListModel(String formProperty) {
        ConfigurableFormModel formModel = (ConfigurableFormModel)this.getFormModel();
        ValueModel valueModel = formModel.getValueModel(formProperty);
        if (!(valueModel instanceof BufferedCollectionValueModel)) {
            valueModel = new BufferedCollectionValueModel(((DefaultFormModel)formModel).getFormObjectPropertyAccessStrategy().getPropertyValueModel(formProperty), formModel.getFieldMetadata(formProperty).getPropertyType());
            formModel.add(formProperty, valueModel);
        }
        return (ObservableList)valueModel.getValue();
    }

    public Binding createBoundList(String formProperty) {
        Map context = this.createContext("selectableItems", this.createBoundListModel(formProperty));
        return this.createBinding(JList.class, formProperty, context);
    }

    public Binding createBoundList(String selectionFormProperty, Object selectableItems) {
        return this.createBoundList(selectionFormProperty, (ValueModel)new ValueHolder(selectableItems));
    }

    public Binding createBoundList(String selectionFormProperty, Object selectableItems, String renderedProperty) {
        return this.createBoundList(selectionFormProperty, (ValueModel)new ValueHolder(selectableItems), renderedProperty);
    }

    public Binding createBoundList(String selectionFormProperty, ValueModel selectableItemsHolder, String renderedProperty) {
        return this.createBoundList(selectionFormProperty, selectableItemsHolder, renderedProperty, null);
    }

    public Binding createBoundList(String selectionFormProperty, ValueModel selectableItemsHolder) {
        return this.createBoundList(selectionFormProperty, selectableItemsHolder, null, null);
    }

    public Binding createBoundList(String selectionFormProperty, Object selectableItems, String renderedProperty, Integer forceSelectMode) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (forceSelectMode != null) {
            context.put("selectionMode", forceSelectMode);
        }
        context.put("selectableItems", selectableItems);
        if (renderedProperty != null) {
            context.put("renderer", new BeanPropertyValueListRenderer(renderedProperty));
            context.put("comparator", new PropertyComparator(renderedProperty, true, true));
        }
        return this.createBinding(JList.class, selectionFormProperty, context);
    }

    protected static class BeanPropertyEditorClosure
    implements Closure {
        private final String renderedProperty;

        public BeanPropertyEditorClosure(String renderedProperty) {
            this.renderedProperty = renderedProperty;
        }

        public Object call(Object argument) {
            Assert.isInstanceOf((Class)(class$javax$swing$ComboBoxEditor == null ? (class$javax$swing$ComboBoxEditor = SwingBindingFactory.class$("javax.swing.ComboBoxEditor")) : class$javax$swing$ComboBoxEditor), (Object)argument);
            return new BeanPropertyValueComboBoxEditor((ComboBoxEditor)argument, this.renderedProperty);
        }

        String getRenderedProperty() {
            return this.renderedProperty;
        }
    }
}

