/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.swing.AsYouTypeTextComponentAdapter;
import org.springframework.richclient.form.binding.support.AbstractBinding;

public class TextComponentBinding
extends AbstractBinding {
    private final JTextComponent textComponent;

    public TextComponentBinding(JTextComponent textComponent, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, String.class);
        this.textComponent = textComponent;
    }

    protected JComponent doBindControl() {
        ValueModel valueModel = this.getValueModel();
        try {
            this.textComponent.setText((String)valueModel.getValue());
        }
        catch (ClassCastException e) {
            IllegalArgumentException ex = new IllegalArgumentException("Class cast exception converting '" + this.getProperty() + "' property value to string - did you install a type converter?");
            ex.initCause(e);
            throw ex;
        }
        new AsYouTypeTextComponentAdapter(this.textComponent, valueModel);
        return this.textComponent;
    }

    protected void readOnlyChanged() {
        this.textComponent.setEditable(!this.isReadOnly());
    }

    protected void enabledChanged() {
        this.textComponent.setEnabled(this.isEnabled());
    }
}

