/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.springframework.richclient.util.OverlayHelper;

public class InterceptorOverlayHelper {
    private InterceptorOverlayHelper() {
    }

    public static void attachOverlay(final JComponent overlay, final JComponent component, final int center, final int xOffset, final int yOffset) {
        if (component.getParent() == null) {
            PropertyChangeListener waitUntilHasParentListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (component.getParent() != null) {
                        component.removePropertyChangeListener("ancestor", this);
                        InterceptorOverlayHelper.doAttachOverlay(overlay, component, center, xOffset, yOffset);
                    }
                }
            };
            component.addPropertyChangeListener("ancestor", waitUntilHasParentListener);
        } else {
            InterceptorOverlayHelper.doAttachOverlay(overlay, component, center, xOffset, yOffset);
        }
    }

    private static void doAttachOverlay(JComponent overlay, JComponent component, int center, int xOffset, int yOffset) {
        JComponent componentToOverlay = InterceptorOverlayHelper.hasParentScrollPane(component) ? InterceptorOverlayHelper.getParentScrollPane(component) : component;
        OverlayHelper.attachOverlay(overlay, componentToOverlay, center, xOffset, yOffset);
    }

    private static JScrollPane getParentScrollPane(JComponent component) {
        return (JScrollPane)component.getParent().getParent();
    }

    private static boolean hasParentScrollPane(JComponent component) {
        return component.getParent() != null && component.getParent() instanceof JViewport && component.getParent().getParent() instanceof JScrollPane;
    }
}

