/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.control.MessageReportingOverlay;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.InterceptorOverlayHelper;
import org.springframework.richclient.form.builder.support.ValidationInterceptor;

public class OverlayValidationInterceptorFactory
implements FormComponentInterceptorFactory {
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new OverlayValidationInterceptor(formModel);
    }

    private static class ErrorReportingOverlay
    extends MessageReportingOverlay {
        private ErrorReportingOverlay() {
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(!enabled);
        }
    }

    public class OverlayValidationInterceptor
    extends ValidationInterceptor {
        public OverlayValidationInterceptor(FormModel formModel) {
            super(formModel);
        }

        public void processComponent(String propertyName, final JComponent component) {
            final ErrorReportingOverlay overlay = new ErrorReportingOverlay();
            this.registerGuarded(propertyName, overlay);
            this.registerMessageReceiver(propertyName, overlay);
            if (component.getParent() == null) {
                PropertyChangeListener waitUntilHasParentListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (component.getParent() != null) {
                            component.removePropertyChangeListener("ancestor", this);
                            OverlayValidationInterceptor.this.attachOverlay(overlay, component);
                        }
                    }
                };
                component.addPropertyChangeListener("ancestor", waitUntilHasParentListener);
            } else {
                this.attachOverlay(overlay, component);
            }
        }

        private void attachOverlay(MessageReportingOverlay overlay, JComponent component) {
            InterceptorOverlayHelper.attachOverlay(overlay, component, 6, 0, 0);
        }
    }
}

