/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.util.Iterator;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.validation.ValidationListener;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.ValidationResultsModel;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.builder.support.AbstractFormComponentInterceptor;

public abstract class ValidationInterceptor
extends AbstractFormComponentInterceptor {
    private final ValidationResultsModel validationResults;

    public ValidationInterceptor(FormModel formModel) {
        super(formModel);
        this.validationResults = ((ValidatingFormModel)formModel).getValidationResults();
    }

    protected ValidationListener registerMessageReceiver(String propertyName, Messagable messageReceiver) {
        MessagableValidationListener messagableValidationListener = new MessagableValidationListener(propertyName, messageReceiver);
        this.validationResults.addValidationListener(propertyName, (ValidationListener)messagableValidationListener);
        messagableValidationListener.validationResultsChanged((ValidationResults)this.validationResults);
        return messagableValidationListener;
    }

    protected ValidationListener registerGuarded(String propertyName, Guarded guarded) {
        GuardedValidationListener guardedValidationListener = new GuardedValidationListener(propertyName, guarded);
        this.validationResults.addValidationListener(propertyName, (ValidationListener)guardedValidationListener);
        guardedValidationListener.validationResultsChanged((ValidationResults)this.validationResults);
        return guardedValidationListener;
    }

    private static class GuardedValidationListener
    implements ValidationListener {
        private final String propertyName;
        private final Guarded guarded;

        public GuardedValidationListener(String propertyName, Guarded guarded) {
            this.propertyName = propertyName;
            this.guarded = guarded;
        }

        public void validationResultsChanged(ValidationResults results) {
            this.guarded.setEnabled(results.getMessageCount(this.propertyName) == 0);
        }
    }

    private static class MessagableValidationListener
    implements ValidationListener {
        private final String propertyName;
        private final Messagable messageReceiver;

        public MessagableValidationListener(String propertyName, Messagable messageReceiver) {
            this.propertyName = propertyName;
            this.messageReceiver = messageReceiver;
        }

        public void validationResultsChanged(ValidationResults results) {
            if (results.getMessageCount(this.propertyName) > 0) {
                ValidationMessage message = this.getNewestMessage(results);
                this.messageReceiver.setMessage((Message)message);
            } else {
                this.messageReceiver.setMessage(null);
            }
        }

        protected ValidationMessage getNewestMessage(ValidationResults results) {
            ValidationMessage newestMessage = null;
            Iterator i = results.getMessages(this.propertyName).iterator();
            while (i.hasNext()) {
                ValidationMessage message = (ValidationMessage)i.next();
                if (newestMessage != null && newestMessage.getTimestamp() >= message.getTimestamp()) continue;
                newestMessage = message;
            }
            return newestMessage;
        }
    }
}

