/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import org.springframework.util.Assert;

public class ArrowIcon
implements Icon {
    private Direction direction;
    private int size;
    private Color color;

    public ArrowIcon(Direction direction) {
        this.setDirection(direction);
        this.setSize(4);
        this.setColor(SystemColor.controlDkShadow);
    }

    public ArrowIcon(Direction direction, int size, Color color) {
        this.setDirection(direction);
        this.setSize(size);
        this.setColor(color);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        for (int i = 0; i < this.size; ++i) {
            if (this.direction == Direction.UP) {
                g.drawLine(x + (this.size - (i + 1)), y + i, x + (this.size + i), y + i);
                continue;
            }
            g.drawLine(x + i, y + i, x + (this.size * 2 - (i + 1)), y + i);
        }
    }

    public int getIconWidth() {
        return this.size * 2;
    }

    public int getIconHeight() {
        return this.size;
    }

    private void setSize(int size) {
        this.size = size;
    }

    private void setColor(Color color) {
        Assert.notNull((Object)color);
        this.color = color;
    }

    private void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[ArrowIcon").append(" direction=").append(this.direction).append(" size=").append(this.size).append(" color=").append(this.color);
        return buf.toString();
    }

    public static class Direction {
        public static final Direction DOWN = new Direction(0);
        public static final Direction UP = new Direction(1);
        private int value;

        private Direction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

