/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.image.ImageSource;
import org.springframework.richclient.image.NoSuchImageResourceException;
import org.springframework.util.CachingMapDecorator;

public class DefaultIconSource
implements IconSource {
    protected static final Log logger = LogFactory.getLog((Class)DefaultIconSource.class);
    private IconCache cache;

    public DefaultIconSource() {
        this((ImageSource)ApplicationServicesLocator.services().getService(ImageSource.class));
    }

    public DefaultIconSource(ImageSource images) {
        this.cache = new IconCache(images);
    }

    public Icon getIcon(String key) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolving icon with key '" + key + "'"));
            }
            return (ImageIcon)this.cache.get(key);
        }
        catch (NoSuchImageResourceException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No image resource found for icon with key '" + key + "'; returning a <null> icon."));
            }
            return null;
        }
    }

    public void clear() {
        this.cache.clear();
    }

    protected String doProcessImageKeyBeforeLookup(String key) {
        return key;
    }

    protected IconCache cache() {
        return this.cache;
    }

    protected static class IconCache
    extends CachingMapDecorator {
        private ImageSource images;

        public IconCache(ImageSource images) {
            super(true);
            this.images = images;
        }

        public Object create(Object key) {
            Image image = this.images.getImage((String)key);
            return new ImageIcon(image);
        }

        public ImageSource images() {
            return this.images;
        }
    }
}

