/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.image.AwtImageResource;
import org.springframework.richclient.image.Handler;
import org.springframework.richclient.image.ImageSource;
import org.springframework.richclient.image.NoSuchImageResourceException;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;

public class DefaultImageSource
implements ImageSource {
    protected static final Log logger = LogFactory.getLog((Class)DefaultImageSource.class);
    private Map imageResources;
    private ImageCache imageCache;
    private AwtImageResource brokenImageIndicatorResource;
    private Image brokenImageIndicator;

    public DefaultImageSource(Map imageResources) {
        this(true, imageResources);
    }

    public DefaultImageSource(boolean installUrlHandler, Map imageResources) {
        Assert.notNull((Object)imageResources);
        this.imageResources = new HashMap(imageResources);
        this.debugPrintResources();
        this.imageCache = new ImageCache();
        if (installUrlHandler) {
            Handler.installImageUrlHandler(this);
        }
    }

    private void debugPrintResources() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialing image source with resources: " + StylerUtils.style((Object)this.imageResources)));
        }
    }

    public Image getImage(String key) {
        Assert.notNull((Object)key);
        AwtImageResource resource = this.getImageResource(key);
        try {
            return (Image)this.imageCache.get(resource);
        }
        catch (RuntimeException e) {
            if (this.brokenImageIndicator != null) {
                return this.returnBrokenImageIndicator((Resource)resource);
            }
            throw e;
        }
    }

    public AwtImageResource getImageResource(String key) {
        Assert.notNull((Object)key);
        Resource resource = (Resource)this.imageResources.get(key);
        if (resource == null) {
            throw new NoSuchImageResourceException((Object)key);
        }
        try {
            resource.getInputStream();
            return new AwtImageResource(resource);
        }
        catch (IOException e) {
            if (this.brokenImageIndicatorResource == null) {
                throw new NoSuchImageResourceException(resource, (Throwable)e);
            }
            logger.warn((Object)("Unable to load image resource at '" + resource + "'; returning the broken image indicator."));
            return this.brokenImageIndicatorResource;
        }
    }

    public boolean containsKey(Object key) {
        return this.imageResources.containsKey(key);
    }

    private Image returnBrokenImageIndicator(Resource resource) {
        logger.warn((Object)("Unable to load image resource at '" + resource + "'; returning the broken image indicator."));
        return this.brokenImageIndicator;
    }

    public Image getImageAtLocation(Resource location) {
        try {
            return new AwtImageResource(location).getImage();
        }
        catch (IOException e) {
            if (this.brokenImageIndicator == null) {
                throw new NoSuchImageResourceException(location, (Throwable)e);
            }
            return this.returnBrokenImageIndicator(location);
        }
    }

    public int size() {
        return this.imageResources.size();
    }

    public void setBrokenImageIndicator(Resource resource) {
        try {
            this.brokenImageIndicatorResource = new AwtImageResource(resource);
            this.brokenImageIndicator = this.brokenImageIndicatorResource.getImage();
        }
        catch (IOException e) {
            this.brokenImageIndicatorResource = null;
            throw new NoSuchImageResourceException(resource, (Throwable)e);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("imageResources", (Object)this.imageResources).toString();
    }

    private static class ImageCache
    extends CachingMapDecorator {
        public ImageCache() {
            super(true);
        }

        public Object create(Object resource) {
            try {
                return ((AwtImageResource)resource).getImage();
            }
            catch (IOException e) {
                throw new NoSuchImageResourceException((Object)("No image found at resource '" + resource + '\"'), (Throwable)e);
            }
        }
    }
}

