/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ShadowedIcon
implements Icon {
    private int shadowWidth = 2;
    private int shadowHeight = 2;
    private Icon icon;
    private Icon shadow;

    public ShadowedIcon(Icon icon) {
        this.icon = icon;
        this.shadow = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
    }

    public ShadowedIcon(Icon icon, int shadowWidth, int shadowHeight) {
        this(icon);
        this.shadowWidth = shadowWidth;
        this.shadowHeight = shadowHeight;
    }

    public int getIconHeight() {
        return this.icon.getIconWidth() + this.shadowWidth;
    }

    public int getIconWidth() {
        return this.icon.getIconHeight() + this.shadowHeight;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.shadow.paintIcon(c, g, x + this.shadowWidth, y + this.shadowHeight);
        this.icon.paintIcon(c, g, x, y);
    }
}

